/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.tools;

import dev.lone.itemsadder.api.CustomStack;
import io.th0rgal.oraxen.api.OraxenItems;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.tools.DivinityToolType;
import studio.magemonkey.mirage.tools.ItemsAdderToolType;
import studio.magemonkey.mirage.tools.OraxenToolType;
import studio.magemonkey.mirage.tools.SapphireToolType;
import studio.magemonkey.mirage.tools.VanillaToolType;
import studio.magemonkey.sapphire.Sapphire;

public abstract class ToolType {
    private static final Set<ToolType> REGISTRY = new HashSet<ToolType>();
    protected final String id;

    @Nullable
    public static ToolType make(String id) {
        if (id.startsWith("SAPPHIRE_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Sapphire")) {
                Mirage.getInstance().getLogger().warning("Ignoring allowed tool \"" + id + "\", Sapphire is not enabled");
                return null;
            }
            if (Sapphire.getItemsRegistry().getItemById(id.substring("SAPPHIRE_".length())) == null) {
                Mirage.getInstance().getLogger().warning("Ignoring unknown Sapphire tool \"" + id + "\"");
                return null;
            }
            return ToolType.canonize(new SapphireToolType(id));
        }
        if (id.startsWith("ORAXEN_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Oraxen")) {
                Mirage.getInstance().getLogger().warning("Ignoring allowed tool \"" + id + "\", Oraxen is not enabled");
                return null;
            }
            if (!OraxenItems.exists((String)id.substring("ORAXEN_".length()))) {
                Mirage.getInstance().getLogger().warning("Ignoring unknown Oraxen tool \"" + id + "\"");
                return null;
            }
            return ToolType.canonize(new OraxenToolType(id));
        }
        if (id.startsWith("ITEMSADDER_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("ItemsAdder")) {
                Mirage.getInstance().getLogger().warning("Ignoring allowed tool \"" + id + "\", ItemsAdder is not enabled");
                return null;
            }
            if (!CustomStack.isInRegistry((String)id.substring("ITEMSADDER_".length()))) {
                Mirage.getInstance().getLogger().warning("Ignoring unknown ItemsAdder tool \"" + id + "\"");
                return null;
            }
            return ToolType.canonize(new ItemsAdderToolType(id));
        }
        if (id.startsWith("DIVINITY_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Divinity")) {
                Mirage.getInstance().getLogger().warning("Ignoring allowed tool \"" + id + "\", Divinity is not enabled");
                return null;
            }
            String itemId = id.substring("DIVINITY_".length());
            boolean found = false;
            for (IModule module : Divinity.getInstance().getModuleManager().getModules()) {
                if (!(module instanceof QModuleDrop) || ((QModuleDrop)module).getItemById(itemId) == null) continue;
                found = true;
                break;
            }
            if (!found) {
                Mirage.getInstance().getLogger().warning("Ignoring unknown Divinity tool \"" + id + "\"");
                return null;
            }
            return ToolType.canonize(new DivinityToolType(id));
        }
        try {
            return ToolType.canonize(new VanillaToolType(Material.valueOf((String)id.trim().toUpperCase().replace(' ', '_').replace('-', '_'))));
        }
        catch (IllegalArgumentException e) {
            Mirage.getInstance().getLogger().warning("Ignoring unknown material tool \"" + id + "\"");
            return null;
        }
    }

    private static ToolType canonize(ToolType toolType) {
        Optional<ToolType> existing = REGISTRY.stream().filter(toolType1 -> toolType1.equals(toolType)).findFirst();
        if (existing.isPresent()) {
            return existing.get();
        }
        REGISTRY.add(toolType);
        return toolType;
    }

    public ToolType(String fullId) {
        if (!fullId.startsWith(this.getPrefix())) {
            throw new IllegalArgumentException();
        }
        this.id = fullId.substring(this.getPrefix().length());
    }

    public abstract String getPrefix();

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        return this.getPrefix() + this.getId();
    }

    public abstract boolean isInstance(ItemStack var1);

    public String toString() {
        return this.getFullId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolType toolType = (ToolType)o;
        return this.id.equals(toolType.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

