/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.rewards;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.rewards.AmountReward;

public class VaultMoneyReward
extends AmountReward {
    private static Economy economy;
    public static String NAME;

    public VaultMoneyReward(String fullString) {
        super(fullString, VaultMoneyReward.parseAmount(fullString));
        RegisteredServiceProvider rsp;
        if (economy == null && Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                throw new IllegalStateException("No Vault Economy implementation found");
            }
        } else {
            throw new IllegalStateException("Vault is not enabled");
        }
        economy = (Economy)rsp.getProvider();
        Mirage.getInstance().getLogger().info("Hooked to Vault economy");
    }

    private static String parseAmount(String fullString) {
        String[] split = fullString.split(":");
        if (split.length != 2) {
            return fullString;
        }
        return split[1];
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    public boolean canAfford(@NotNull Player player) {
        if (economy == null) {
            throw new IllegalStateException("Vault is not enabled");
        }
        return economy.getBalance((OfflinePlayer)player) >= -this.amount;
    }

    @Override
    public void apply(@NotNull Player player) {
        if (economy == null) {
            throw new IllegalStateException("Vault is not enabled");
        }
        if (this.amount >= 0.0) {
            economy.depositPlayer((OfflinePlayer)player, this.amount);
        } else {
            economy.withdrawPlayer((OfflinePlayer)player, -this.amount);
        }
    }

    static {
        NAME = "VAULT_money";
    }
}

