/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.rewards;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.mirage.rewards.AmountReward;

public class VanillaExpReward
extends AmountReward {
    public static String NAME = "exp";

    public VanillaExpReward(String fullString) {
        super(fullString, VanillaExpReward.parseAmount(fullString));
    }

    private static String parseAmount(String fullString) {
        String[] split = fullString.split(":");
        if (split.length != 2) {
            return fullString;
        }
        return split[1];
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    public boolean canAfford(@NotNull Player player) {
        return (double)this.getTotalExp(player) >= -this.amount;
    }

    @Override
    public void apply(@NotNull Player player) {
        if (this.amount >= 0.0) {
            player.giveExp((int)this.amount);
        } else {
            int totalExp = this.getTotalExp(player);
            int totalScore = player.getTotalExperience();
            player.setLevel(0);
            player.setExp(0.0f);
            player.giveExp(totalExp + (int)this.amount);
            player.setTotalExperience(totalScore);
        }
    }

    private int getTotalExp(Player player) {
        int level = player.getLevel();
        int currentAmount = level < 17 ? level * level + 6 * level : (level < 32 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        float exp = player.getExp();
        currentAmount = level < 16 ? (int)((float)currentAmount + exp * (float)(2 * level + 7)) : (level < 31 ? (int)((float)currentAmount + exp * (float)(5 * level - 38)) : (int)((float)currentAmount + exp * (float)(9 * level - 158)));
        return currentAmount;
    }
}

