/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.rewards;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.mirage.rewards.FabledExpReward;
import studio.magemonkey.mirage.rewards.FabledSkillReward;
import studio.magemonkey.mirage.rewards.JobsExpReward;
import studio.magemonkey.mirage.rewards.JobsMoneyReward;
import studio.magemonkey.mirage.rewards.JobsPointsReward;
import studio.magemonkey.mirage.rewards.McMMOExperienceReward;
import studio.magemonkey.mirage.rewards.VanillaExpReward;
import studio.magemonkey.mirage.rewards.VaultMoneyReward;

public abstract class Reward {
    public static Reward make(String string) {
        if (string.startsWith(VanillaExpReward.NAME)) {
            return new VanillaExpReward(string);
        }
        if (string.startsWith(VaultMoneyReward.NAME)) {
            return new VaultMoneyReward(string);
        }
        if (string.startsWith("JOBS_money")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                throw new IllegalStateException("Jobs is not enabled");
            }
            return new JobsMoneyReward(string);
        }
        if (string.startsWith("JOBS_exp")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                throw new IllegalStateException("Jobs is not enabled");
            }
            return new JobsExpReward(string);
        }
        if (string.startsWith("JOBS_points")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                throw new IllegalStateException("Jobs is not enabled");
            }
            return new JobsPointsReward(string);
        }
        if (string.startsWith("FABLED_skill")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                throw new IllegalStateException("Fabled is not enabled");
            }
            return new FabledSkillReward(string);
        }
        if (string.startsWith("FABLED_exp")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                throw new IllegalStateException("Fabled is not enabled");
            }
            return new FabledExpReward(string);
        }
        if (string.startsWith("MCMMO_exp")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                throw new IllegalStateException("mcMMO is not enabled");
            }
            return new McMMOExperienceReward(string);
        }
        throw new IllegalArgumentException("Unknown name");
    }

    public Reward(String fullString) {
        if (!fullString.startsWith(this.getName())) {
            throw new IllegalArgumentException();
        }
    }

    @NotNull
    public abstract String getName();

    public abstract void apply(@NotNull Player var1);

    public String[] getMessageArgs() {
        return new String[0];
    }
}

