/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.requirements;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.mirage.requirements.EnchantmentRequirement;
import studio.magemonkey.mirage.requirements.FabledClassRequirement;
import studio.magemonkey.mirage.requirements.FabledSkillRequirement;
import studio.magemonkey.mirage.requirements.FusionProfessionRequirement;
import studio.magemonkey.mirage.requirements.JobsJobRequirement;
import studio.magemonkey.mirage.requirements.McMMOSkillRequirement;

public abstract class Requirement {
    private final String fullString;

    public static Requirement make(String string) {
        if (string.startsWith("enchantment")) {
            return new EnchantmentRequirement(string);
        }
        if (string.startsWith("FABLED_skill")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                throw new IllegalStateException("Fabled is not enabled");
            }
            return new FabledSkillRequirement(string);
        }
        if (string.startsWith("FABLED_class")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                throw new IllegalStateException("Fabled is not enabled");
            }
            return new FabledClassRequirement(string);
        }
        if (string.startsWith("JOBS_job")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                throw new IllegalStateException("Jobs is not enabled");
            }
            return new JobsJobRequirement(string);
        }
        if (string.startsWith("MCMMO_skill")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                throw new IllegalStateException("mcMMO is not enabled");
            }
            return new McMMOSkillRequirement(string);
        }
        if (string.startsWith("FUSION_profession") || string.startsWith("RPGCRAFTING_profession")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Fusion")) {
                throw new IllegalStateException("Fusion is not enabled");
            }
            return new FusionProfessionRequirement(string);
        }
        throw new IllegalArgumentException("Unknown name");
    }

    public Requirement(String fullString) {
        if (!fullString.split(":")[0].equalsIgnoreCase(this.getName())) {
            throw new IllegalArgumentException();
        }
        this.fullString = fullString;
    }

    @NotNull
    public abstract String getName();

    public abstract boolean meets(@NotNull Player var1);

    public String toString() {
        return this.fullString;
    }
}

