/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage.blocks;

import dev.lone.itemsadder.api.CustomBlock;
import io.th0rgal.oraxen.api.OraxenBlocks;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.blocks.ItemsAdderBlockType;
import studio.magemonkey.mirage.blocks.OraxenBlockType;
import studio.magemonkey.mirage.blocks.VanillaBlockType;

public abstract class BlockType {
    private static final Set<BlockType> REGISTRY = new HashSet<BlockType>();
    protected final String id;

    @Nullable
    public static BlockType make(String id, boolean warn) {
        if (id.startsWith("ORAXEN_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("Oraxen")) {
                BlockType.invalidBlock("Ignoring block id \"" + id + "\", Oraxen is not enabled", warn);
                return null;
            }
            if (!OraxenBlocks.isOraxenBlock((String)id.substring("ORAXEN_".length()))) {
                BlockType.invalidBlock("Ignoring unknown Oraxen block id \"" + id + "\"", warn);
                return null;
            }
            return BlockType.canonize(new OraxenBlockType(id));
        }
        if (id.startsWith("ITEMSADDER_")) {
            if (!Bukkit.getPluginManager().isPluginEnabled("ItemsAdder")) {
                BlockType.invalidBlock("Ignoring block id \"" + id + "\", ItemsAdder is not enabled", warn);
                return null;
            }
            if (!CustomBlock.isInRegistry((String)id.substring("ITEMSADDER_".length()))) {
                BlockType.invalidBlock("Ignoring unknown ItemsAdder block id \"" + id + "\"", warn);
                return null;
            }
            return BlockType.canonize(new ItemsAdderBlockType(id));
        }
        try {
            return BlockType.canonize(new VanillaBlockType(id));
        }
        catch (IllegalArgumentException e) {
            BlockType.invalidBlock(e.getMessage(), warn);
            return null;
        }
    }

    private static BlockType canonize(BlockType blockType) {
        Optional<BlockType> existing = REGISTRY.stream().filter(blockType1 -> blockType1.equals(blockType)).findFirst();
        if (existing.isPresent()) {
            return existing.get();
        }
        REGISTRY.add(blockType);
        return blockType;
    }

    private static void invalidBlock(String message, boolean warn) {
        if (warn) {
            Mirage.getInstance().getLogger().warning(message);
        }
    }

    public BlockType(String fullId) {
        if (!fullId.startsWith(this.getPrefix())) {
            throw new IllegalArgumentException();
        }
        this.id = fullId.substring(this.getPrefix().length());
    }

    public abstract String getPrefix();

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        return this.getPrefix() + this.getId();
    }

    public abstract boolean isInstance(Block var1);

    public abstract void place(Block var1);

    public void handleBreak(BlockBreakEvent event) {
        event.getBlock().breakNaturally(event.getPlayer().getInventory().getItemInMainHand());
    }

    public String toString() {
        return this.getFullId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockType blockType = (BlockType)o;
        return this.id.equals(blockType.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

