/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.angeschossen.lands.api.integration.LandsIntegration;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.mirage.CommandExec;
import studio.magemonkey.mirage.CropListener;
import studio.magemonkey.mirage.Data;
import studio.magemonkey.mirage.InteractListener;
import studio.magemonkey.mirage.Lang;

public class Mirage
extends JavaPlugin {
    private static Mirage instance;
    private final Data data = new Data();
    private Lang lang;
    private final List<String> disabledRegions = new ArrayList<String>();
    private boolean regionsBlacklisted;
    private boolean worldGuardEnabled;
    private final List<String> disabledWorlds = new ArrayList<String>();
    private boolean worldsBlacklisted;
    private boolean townyHookEnabled;
    private boolean factionsUUIDEnabled;
    private boolean residenceEnabled;
    private boolean griefPreventionEnabled;
    private boolean protectionStonesEnabled;
    private boolean griefDefenderEnabled;
    private LandsIntegration landsIntegration;
    private boolean debug = false;

    public boolean areRegionsBlacklisted() {
        return this.regionsBlacklisted;
    }

    public void debug(String message) {
        if (this.debug) {
            this.getLogger().info(message);
        }
    }

    public boolean areWorldsBlacklisted() {
        return this.worldsBlacklisted;
    }

    public void onEnable() {
        instance = this;
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.getLogger().info("Saving default config.");
            this.saveDefaultConfig();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CropListener(), (Plugin)this);
        this.getData().load((ConfigurationSection)this.getConfig());
        this.getData().setStorageFile(new File(this.getDataFolder(), "regen.yml"));
        this.worldGuardEnabled = this.getServer().getPluginManager().getPlugin("WorldGuard") != null;
        this.townyHookEnabled = this.getConfig().getBoolean("towny") && this.getServer().getPluginManager().getPlugin("Towny") != null;
        this.factionsUUIDEnabled = this.getConfig().getBoolean("factionsuuid") && this.getServer().getPluginManager().getPlugin("Factions") != null;
        this.residenceEnabled = this.getConfig().getBoolean("residence") && this.getServer().getPluginManager().getPlugin("Residence") != null;
        this.griefPreventionEnabled = this.getConfig().getBoolean("grief-prevention") && this.getServer().getPluginManager().getPlugin("GriefPrevention") != null;
        this.protectionStonesEnabled = this.getConfig().getBoolean("protections-stones") && this.getServer().getPluginManager().getPlugin("ProtectionStones") != null;
        this.griefDefenderEnabled = this.getConfig().getBoolean("grief-defender") && this.getServer().getPluginManager().getPlugin("GriefDefender") != null;
        this.landsIntegration = this.getConfig().getBoolean("lands") && this.getServer().getPluginManager().getPlugin("Lands") != null ? new LandsIntegration((Plugin)this) : null;
        try {
            this.getData().loadRegenerationEntries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.debug = this.getConfig().getBoolean("debug", false);
        this.regionsBlacklisted = true;
        if (this.getConfig().contains("disabled-regions.list")) {
            this.disabledRegions.addAll(this.getConfig().getStringList("disabled-regions.list"));
            this.regionsBlacklisted = !this.getConfig().getBoolean("disabled-regions.whitelist", false);
        }
        this.worldsBlacklisted = true;
        if (this.getConfig().contains("disabled-worlds.list")) {
            this.disabledWorlds.addAll(this.getConfig().getStringList("disabled-worlds.list"));
            this.worldsBlacklisted = !this.getConfig().getBoolean("disabled-worlds.whitelist", false);
        }
        this.lang = new Lang(this);
        this.getData().startRegenerationWatchdog();
        CommandExec cmd = new CommandExec();
        this.getCommand("resources").setExecutor((CommandExecutor)cmd);
        this.getCommand("resources").setTabCompleter((TabCompleter)cmd);
        this.getLogger().info("v" + this.getDescription().getVersion() + " Enabled");
    }

    public void onDisable() {
        this.getData().stopRegenerationWatchdog();
        try {
            this.getData().saveRegenerationEntries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getLogger().info("v" + this.getDescription().getVersion() + " Disabled");
    }

    public void reloadConfigs() {
        this.reloadConfig();
        this.getData().load((ConfigurationSection)this.getConfig());
        this.debug = this.getConfig().getBoolean("debug", false);
        this.disabledRegions.clear();
        this.regionsBlacklisted = true;
        if (this.getConfig().contains("disabled-regions.list")) {
            this.disabledRegions.addAll(this.getConfig().getStringList("disabled-regions.list"));
            this.regionsBlacklisted = !this.getConfig().getBoolean("disabled-regions.whitelist", false);
        }
        this.disabledWorlds.clear();
        this.worldsBlacklisted = true;
        if (this.getConfig().contains("disabled-worlds.list")) {
            this.disabledWorlds.addAll(this.getConfig().getStringList("disabled-worlds.list"));
            this.worldsBlacklisted = !this.getConfig().getBoolean("disabled-worlds.whitelist", false);
        }
        this.lang = new Lang(this);
    }

    @Generated
    public static Mirage getInstance() {
        return instance;
    }

    @Generated
    public Data getData() {
        return this.data;
    }

    @Generated
    public Lang getLang() {
        return this.lang;
    }

    @Generated
    public List<String> getDisabledRegions() {
        return this.disabledRegions;
    }

    @Generated
    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    @Generated
    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    @Generated
    public boolean isTownyHookEnabled() {
        return this.townyHookEnabled;
    }

    @Generated
    public boolean isFactionsUUIDEnabled() {
        return this.factionsUUIDEnabled;
    }

    @Generated
    public boolean isResidenceEnabled() {
        return this.residenceEnabled;
    }

    @Generated
    public boolean isGriefPreventionEnabled() {
        return this.griefPreventionEnabled;
    }

    @Generated
    public boolean isProtectionStonesEnabled() {
        return this.protectionStonesEnabled;
    }

    @Generated
    public boolean isGriefDefenderEnabled() {
        return this.griefDefenderEnabled;
    }

    @Generated
    public LandsIntegration getLandsIntegration() {
        return this.landsIntegration;
    }
}

