/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage;

import java.io.File;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.rewards.AmountReward;
import studio.magemonkey.mirage.rewards.JobsExpReward;
import studio.magemonkey.mirage.rewards.JobsMoneyReward;
import studio.magemonkey.mirage.rewards.JobsPointsReward;
import studio.magemonkey.mirage.rewards.Reward;
import studio.magemonkey.mirage.rewards.VanillaExpReward;
import studio.magemonkey.mirage.rewards.VaultMoneyReward;

public class Lang {
    private final HashMap<Class<? extends Reward>, String> cannotAfford = new HashMap();
    private final HashMap<Class<? extends Reward>, String> deducted = new HashMap();
    private final HashMap<Class<? extends Reward>, String> rewarded = new HashMap();

    public Lang(Mirage plugin) {
        File file = new File(plugin.getDataFolder(), "lang.yml");
        if (!file.exists()) {
            plugin.saveResource("lang.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.loadRewardClass(config, VanillaExpReward.class, VanillaExpReward.NAME);
        this.loadRewardClass(config, VaultMoneyReward.class, VaultMoneyReward.NAME);
        this.loadRewardClass(config, JobsMoneyReward.class, "JOBS_money");
        this.loadRewardClass(config, JobsExpReward.class, "JOBS_exp");
        this.loadRewardClass(config, JobsPointsReward.class, "JOBS_points");
    }

    private void loadRewardClass(YamlConfiguration config, Class<? extends Reward> clazz, String name) {
        String value = config.getString("rewards.cannot-afford." + name);
        if (value != null) {
            this.cannotAfford.put(clazz, ChatColor.translateAlternateColorCodes((char)'&', (String)value));
        }
        if ((value = config.getString("rewards.deducted." + name)) != null) {
            this.deducted.put(clazz, ChatColor.translateAlternateColorCodes((char)'&', (String)value));
        }
        if ((value = config.getString("rewards.rewarded." + name)) != null) {
            this.rewarded.put(clazz, ChatColor.translateAlternateColorCodes((char)'&', (String)value));
        }
    }

    public void sendCannotAffordMessage(Player player, AmountReward reward) {
        String message = this.cannotAfford.get(reward.getClass());
        if (message != null && !message.equals("")) {
            message = message.replace("{amount}", String.valueOf(-reward.getAmount()));
            String[] args = reward.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + String.valueOf(i) + "}", args[0]);
            }
            player.sendMessage(message);
        }
    }

    public void sendDeductedMessage(Player player, AmountReward reward) {
        String message = this.deducted.get(reward.getClass());
        if (message != null && !message.equals("")) {
            message = message.replace("{amount}", String.valueOf(-reward.getAmount()));
            String[] args = reward.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + String.valueOf(i) + "}", args[0]);
            }
            player.sendMessage(message);
        }
    }

    public void sendRewardedMessage(Player player, AmountReward reward) {
        String message = this.rewarded.get(reward.getClass());
        if (message != null && !message.equals("")) {
            message = message.replace("{amount}", String.valueOf(reward.getAmount()));
            String[] args = reward.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + String.valueOf(i) + "}", args[0]);
            }
            player.sendMessage(message);
        }
    }
}

