/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage;

import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import dev.espi.protectionstones.ProtectionStones;
import java.util.Map;
import java.util.Optional;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.mirage.DataEntry;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.blocks.BlockType;
import studio.magemonkey.mirage.hooks.FactionsUUIDHook;
import studio.magemonkey.mirage.hooks.LandsHook;
import studio.magemonkey.mirage.hooks.TownyHook;
import studio.magemonkey.mirage.hooks.WorldGuardHook;
import studio.magemonkey.mirage.rewards.AmountReward;

public class InteractListener
implements Listener {
    private final Mirage plugin = Mirage.getInstance();

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        boolean worldProtected;
        boolean matchFound = this.plugin.getDisabledWorlds().contains(event.getBlock().getWorld().getName());
        boolean bl = worldProtected = this.plugin.areWorldsBlacklisted() == matchFound;
        if (worldProtected) {
            this.plugin.debug("This world is protected.");
            return;
        }
        if (event.getPlayer().hasPermission("mirage.override")) {
            return;
        }
        if (this.isProtected(event.getBlock())) {
            return;
        }
        this.plugin.debug(String.valueOf(event.getBlock().getType()) + " has been broken.");
        Optional<Map.Entry<BlockType, DataEntry>> entry = this.plugin.getData().match(event);
        event.setCancelled(true);
        if (this.plugin.getData().isRegenerating(event.getBlock())) {
            this.plugin.debug("That block is already regenerating");
            return;
        }
        if (entry.isEmpty()) {
            this.plugin.debug("Entry is not present.");
            return;
        }
        DataEntry dataEntry = entry.get().getValue();
        this.plugin.debug("This is a Mirage resource.");
        if (!dataEntry.isUsableTool(event.getPlayer().getInventory().getItemInMainHand())) {
            String toolMessage = dataEntry.getToolMessage();
            if (toolMessage != null) {
                event.getPlayer().sendMessage(toolMessage);
            }
            return;
        }
        this.plugin.debug("We're using the correct tool.");
        if (!dataEntry.meetsRequirements(event.getPlayer())) {
            return;
        }
        AmountReward cost = dataEntry.applyCostsAndRewards(event.getPlayer(), true);
        if (cost != null) {
            this.plugin.debug("Cannot afford " + cost.getAmount() + " " + cost.getName());
            return;
        }
        this.plugin.debug("Mining costs deducted");
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            int maxDamage = item.getType().getMaxDurability();
            int unbreakingLevel = item.getEnchantmentLevel(Enchantment.UNBREAKING);
            if (unbreakingLevel > 0) {
                double chance = 100.0 / (double)(unbreakingLevel + 1);
                if (Math.random() * 100.0 < chance) {
                    this.plugin.debug("Unbreaking prevented damage");
                    return;
                }
            }
            if (maxDamage > 0) {
                int newDamage;
                boolean indestructible = item.getType().equals((Object)Material.ELYTRA);
                if (indestructible) {
                    --maxDamage;
                }
                if ((newDamage = damageable.getDamage() + dataEntry.getToolDamage()) >= maxDamage) {
                    if (indestructible) {
                        this.plugin.debug("Can't use item over max durability");
                        return;
                    }
                    damageable.setDamage(0);
                    item.setItemMeta(meta);
                    Player player = event.getPlayer();
                    Bukkit.getPluginManager().callEvent((Event)new PlayerItemBreakEvent(player, item));
                    item.setAmount(item.getAmount() - 1);
                    player.playSound(player.getEyeLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else {
                    damageable.setDamage(newDamage);
                    item.setItemMeta(meta);
                }
            }
        }
        if (!dataEntry.cancelDrop()) {
            entry.get().getKey().handleBreak(event);
        }
        event.getPlayer().getInventory().setItemInMainHand(item);
        this.plugin.debug("Tool has been damaged and applied. Executing any commands.");
        dataEntry.executeCommands(event.getPlayer());
        this.plugin.debug("Updating the block to the break material.");
        dataEntry.getBreakMaterial().place(event.getBlock());
        event.getBlock().getState().update();
        this.plugin.debug("Block broken and updated. Starting regeneration task.");
        this.plugin.getData().addRegenerationEntry(event.getBlock(), entry.get(), true);
        this.plugin.debug(String.format("Resource broken (%s) at (%d, %d, %d) by %s", entry.get().getKey().toString(), event.getBlock().getX(), event.getBlock().getY(), event.getBlock().getZ(), event.getPlayer().getName()));
    }

    private boolean isProtected(Block block) {
        Claim claim;
        if (this.plugin.isWorldGuardEnabled() && WorldGuardHook.isRegionDisabledAt(block.getLocation())) {
            this.plugin.debug("This is in a WG disabled region.");
            return true;
        }
        if (this.plugin.isTownyHookEnabled() && TownyHook.isClaimed(block.getLocation())) {
            this.plugin.debug("This is in a Towny claimed chunk.");
            return true;
        }
        if (this.plugin.isFactionsUUIDEnabled() && FactionsUUIDHook.isClaimed(block.getLocation())) {
            this.plugin.debug("This is in a FactionsUUID claimed chunk.");
            return true;
        }
        if (this.plugin.isResidenceEnabled() && ResidenceApi.getResidenceManager().getByLoc(block.getLocation()) != null) {
            this.plugin.debug("This is in a Residence claimed region.");
            return true;
        }
        if (this.plugin.isGriefPreventionEnabled() && GriefPrevention.instance.dataStore.getClaimAt(block.getLocation(), false, null) != null) {
            this.plugin.debug("This is in a GriefPrevention claimed region.");
            return true;
        }
        if (this.plugin.isProtectionStonesEnabled() && ProtectionStones.isProtectBlock((Block)block)) {
            this.plugin.debug("This is in a ProtectionStones protected block.");
            return true;
        }
        if (this.plugin.isGriefDefenderEnabled() && (claim = GriefDefender.getCore().getClaimAt((Object)block.getLocation())) != null && !claim.isWilderness()) {
            this.plugin.debug("This is in a ProtectionStones protected block.");
            return true;
        }
        if (this.plugin.getLandsIntegration() != null && LandsHook.isClaimed(block.getLocation())) {
            this.plugin.debug("This is a Lands-Area");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getData().checkChunkRegeneration(event.getChunk()), 1L);
    }
}

