/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.mirage.Lang;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.blocks.BlockType;
import studio.magemonkey.mirage.requirements.Requirement;
import studio.magemonkey.mirage.rewards.AmountReward;
import studio.magemonkey.mirage.rewards.Reward;
import studio.magemonkey.mirage.tools.ToolType;

public class DataEntry {
    private final Set<BlockType> materials = new HashSet<BlockType>();
    private final BlockType breakMaterial;
    private final Long regenerationDelay;
    private final Set<ToolType> tools = new HashSet<ToolType>();
    private final List<Requirement> requirements = new ArrayList<Requirement>();
    private final List<Reward> rewards = new ArrayList<Reward>();
    private final List<AmountReward> costs = new ArrayList<AmountReward>();
    private final TreeMap<Double, BlockType> chance = new TreeMap();
    private final double totalWeight;
    private final List<Command> commands = new ArrayList<Command>();
    private String toolMessage;
    private int toolDamage = 0;
    private Integer age;
    private final boolean cancelDrop;

    /*
     * WARNING - void declaration
     */
    public DataEntry(Map<String, Object> map) {
        BlockType blockType;
        Validate.notNull(map);
        Object object = map.getOrDefault("materials", map.get("material"));
        if (object instanceof List) {
            List materialsList = (List)object;
            for (Object obj : materialsList) {
                BlockType blockType2;
                if (!(obj instanceof String) || (blockType2 = BlockType.make((String)obj, true)) == null) continue;
                this.materials.add(blockType2);
            }
        } else if (object instanceof String && (blockType = BlockType.make((String)object, true)) != null) {
            this.materials.add(blockType);
        }
        if (this.materials.isEmpty()) {
            throw new IllegalArgumentException("At least one material is required");
        }
        object = map.get("break-material");
        this.breakMaterial = object instanceof String ? BlockType.make((String)object, false) : null;
        if (this.breakMaterial == null) {
            throw new IllegalArgumentException("Invalid 'break-material' value: " + String.valueOf(object));
        }
        this.cancelDrop = (Boolean)map.get("cancel-drop");
        this.regenerationDelay = (long)((Integer)map.get("regen-delay"));
        if (map.containsKey("tool")) {
            Validate.isTrue((boolean)(map.get("tool") instanceof Map), (String)"'tool' must be a section.", (Object[])new Object[0]);
            Map tools = (Map)map.get("tool");
            if (tools.containsKey("allowed")) {
                List stringList;
                Object allowedObject = tools.get("allowed");
                if (allowedObject instanceof String) {
                    stringList = new ArrayList<String>();
                    stringList.add((String)allowedObject);
                } else {
                    if (!(allowedObject instanceof List)) {
                        throw new IllegalArgumentException("Invalid data type.");
                    }
                    stringList = (List)allowedObject;
                }
                for (String toolString : stringList) {
                    ToolType toolType = ToolType.make(toolString);
                    if (toolType == null) continue;
                    this.tools.add(toolType);
                }
            }
            if ((object = map.get("requirements")) instanceof List) {
                List list = (List)object;
                for (Object e : list) {
                    try {
                        this.requirements.add(Requirement.make((String)e));
                    }
                    catch (ClassCastException | IllegalArgumentException | IllegalStateException e2) {
                        Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(e) + "\": " + e2.getMessage());
                    }
                    catch (Exception e3) {
                        Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(e) + "\":");
                        e3.printStackTrace();
                    }
                }
            } else if (object instanceof String) {
                try {
                    this.requirements.add(Requirement.make((String)object));
                }
                catch (ClassCastException | IllegalArgumentException | IllegalStateException e) {
                    Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(object) + "\": " + e.getMessage());
                }
                catch (Exception e) {
                    Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(object) + "\":");
                    e.printStackTrace();
                }
            }
            this.toolMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)tools.getOrDefault("message", null));
            this.toolDamage = tools.getOrDefault("damage", 0);
        }
        double totalWeight = 0.0;
        object = map.get("chance");
        if (object instanceof Map) {
            Map chanceMap = (Map)object;
            for (Map.Entry entry : chanceMap.entrySet()) {
                void blockType3;
                double chance;
                Object key = entry.getKey();
                if (key instanceof String) {
                    BlockType blockType32 = BlockType.make((String)key, true);
                    if (blockType32 == null) {
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException("Ignoring invalid 'chance' key: " + String.valueOf(key));
                }
                Object weight = entry.getValue();
                if (weight instanceof Number) {
                    chance = ((Number)weight).doubleValue();
                    if (chance == 0.0) {
                        Mirage.getInstance().getLogger().warning("Ignoring 'chance' key with 0 weight: " + String.valueOf(key));
                        continue;
                    }
                } else {
                    Mirage.getInstance().getLogger().warning("Ignoring invalid 'chance' weight: " + String.valueOf(weight));
                    continue;
                }
                this.chance.put(totalWeight += chance, (BlockType)blockType3);
            }
        } else if (object != null) {
            throw new IllegalArgumentException("Invalid 'chance' section: " + String.valueOf(object));
        }
        this.totalWeight = totalWeight;
        object = map.get("rewards");
        if (object instanceof List) {
            List list = (List)object;
            for (Object obj : list) {
                if (!(obj instanceof String)) continue;
                try {
                    Reward reward = Reward.make((String)obj);
                    if (reward instanceof AmountReward && ((AmountReward)reward).getAmount() < 0.0) {
                        this.costs.add((AmountReward)reward);
                        continue;
                    }
                    this.rewards.add(reward);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(obj) + "\": " + e.getMessage());
                }
                catch (Exception e) {
                    Mirage.getInstance().getLogger().warning("Ignoring invalid reward/cost \"" + String.valueOf(obj) + "\":");
                    e.printStackTrace();
                }
            }
        }
        if (map.containsKey("command")) {
            Validate.isTrue((boolean)(map.get("command") instanceof List), (String)"'command' section must be a list", (Object[])new Object[0]);
            List commandList = (List)map.get("command");
            this.commands.addAll(commandList.stream().map(Command::new).collect(Collectors.toList()));
        }
        if (map.containsKey("age")) {
            this.age = (int)((Integer)map.get("age"));
        }
        Mirage.getInstance().debug("Created DataEntry for materials:");
        for (BlockType blockType4 : this.materials) {
            Mirage.getInstance().debug("- " + blockType4.getPrefix());
        }
    }

    public boolean isUsableTool(ItemStack itemStack) {
        if (this.tools.isEmpty()) {
            return true;
        }
        for (ToolType toolType : this.tools) {
            if (!toolType.isInstance(itemStack)) continue;
            return true;
        }
        return false;
    }

    public boolean meetsRequirements(Player player) {
        for (Requirement requirement : this.requirements) {
            if (requirement.meets(player)) continue;
            Mirage.getInstance().debug("Requirement not met: " + String.valueOf(requirement));
            return false;
        }
        return true;
    }

    @Nullable
    public AmountReward applyCostsAndRewards(Player player, boolean apply) {
        Lang lang = Mirage.getInstance().getLang();
        for (AmountReward cost : this.costs) {
            if (cost.canAfford(player)) continue;
            lang.sendCannotAffordMessage(player, cost);
            return cost;
        }
        if (apply) {
            for (AmountReward cost : this.costs) {
                cost.apply(player);
                lang.sendDeductedMessage(player, cost);
            }
            for (Reward reward : this.rewards) {
                reward.apply(player);
                if (!(reward instanceof AmountReward)) continue;
                lang.sendRewardedMessage(player, (AmountReward)reward);
            }
        }
        return null;
    }

    public void executeCommands(Player player) {
        this.commands.forEach(c -> c.execute(player));
    }

    @Nullable
    public BlockType chance() {
        if (this.chance.isEmpty()) {
            return null;
        }
        return this.chance.ceilingEntry(Math.random() * this.totalWeight).getValue();
    }

    public Set<BlockType> getMaterials() {
        return Collections.unmodifiableSet(this.materials);
    }

    public BlockType getBreakMaterial() {
        return this.breakMaterial;
    }

    public Long getRegenerationDelay() {
        return this.regenerationDelay;
    }

    public Collection<ToolType> getTools() {
        return Collections.unmodifiableCollection(this.tools);
    }

    @Nullable
    public String getToolMessage() {
        return this.toolMessage;
    }

    public int getToolDamage() {
        return this.toolDamage;
    }

    public Map<Double, BlockType> getChanceMap() {
        return Collections.unmodifiableMap(this.chance);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public boolean cancelDrop() {
        return this.cancelDrop;
    }

    public boolean isAgeable() {
        return this.age != null;
    }

    public int getAge() {
        return this.age;
    }

    public static class Command {
        protected final Integer delay;
        protected final As as;
        protected final String cmd;
        protected final double chance;

        public Command(Map<String, Object> map) {
            this.delay = (Integer)map.getOrDefault("delay", 0);
            this.as = As.valueOf((String)map.getOrDefault("as", "PLAYER"));
            this.cmd = map.getOrDefault("cmd", null);
            this.chance = Math.min(Math.max(0.0, Double.parseDouble(String.valueOf(map.getOrDefault("chance", 100))) * 0.01), 1.0);
        }

        public void execute(Player player) {
            if (this.chance <= Math.random()) {
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)Mirage.getInstance(), () -> {
                Object sender = this.as == As.PLAYER ? player : Bukkit.getConsoleSender();
                String cmd = this.cmd;
                cmd = StringUtils.replace((String)cmd, (String)"{player}", (String)player.getName());
                Bukkit.dispatchCommand((CommandSender)((CommandSender)sender), (String)cmd);
            }, (long)this.delay.intValue() * 20L);
        }

        public static enum As {
            CONSOLE,
            OP,
            PLAYER;

        }
    }
}

