/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.mirage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.mirage.DataEntry;
import studio.magemonkey.mirage.Mirage;
import studio.magemonkey.mirage.RegenerationEntry;
import studio.magemonkey.mirage.blocks.BlockType;

public class Data {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final Long watchdogInterval = 900L;
    private static final Long watchdogIntervalTicks = watchdogInterval * 20L;
    public static boolean restrictCropGrowth = true;
    public static boolean restrictMelonGrowth = true;
    public static boolean restrictTurtleEgg = false;
    public static boolean restrictBlockGrowth = true;
    private final Map<BlockType, DataEntry> entries = new HashMap<BlockType, DataEntry>();
    private final Collection<RegenerationEntry> regenerationEntries = new HashSet<RegenerationEntry>();
    private final Map<Location, BukkitTask> tasks = new HashMap<Location, BukkitTask>();
    private File storageFile;
    private BukkitTask watchdog = null;

    public void load(ConfigurationSection section) {
        this.entries.clear();
        section.getMapList("entries").stream().map(map -> {
            try {
                return new DataEntry((Map<String, Object>)map);
            }
            catch (Exception e) {
                Mirage.getInstance().getLogger().info("Invalid entry: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).forEach(dataEntry -> {
            for (BlockType blockType : dataEntry.getMaterials()) {
                DataEntry existing = this.entries.put(blockType, (DataEntry)dataEntry);
                Mirage.getInstance().debug("Registered entry for block type '" + String.valueOf(blockType) + "'");
                if (existing == null) continue;
                Mirage.getInstance().debug("Overriding duplicate block type '" + String.valueOf(blockType) + "'");
            }
        });
        restrictCropGrowth = section.getBoolean("disable_crop_growth");
        restrictMelonGrowth = section.getBoolean("disable_melon_growth");
        restrictTurtleEgg = section.getBoolean("disable_turtle_egg");
        restrictBlockGrowth = section.getBoolean("disable_block_growth");
        Mirage.getInstance().getLogger().info("Loaded " + this.entries.size() + " entries.");
    }

    public Optional<Map.Entry<BlockType, DataEntry>> match(Block block) {
        for (Map.Entry<BlockType, DataEntry> entry : this.entries.entrySet()) {
            BlockType blockType = entry.getKey();
            Mirage.getInstance().debug("Comparing broken " + String.valueOf(block.getType()) + " with " + String.valueOf(blockType));
            if (!blockType.isInstance(block)) {
                Mirage.getInstance().debug("Not a match.");
                continue;
            }
            Mirage.getInstance().debug("We have a match.");
            return Optional.of(entry);
        }
        Mirage.getInstance().debug("No matches found.");
        return Optional.empty();
    }

    public Optional<Map.Entry<BlockType, DataEntry>> match(BlockType blockType) {
        for (Map.Entry<BlockType, DataEntry> entry : this.entries.entrySet()) {
            BlockType blockType1 = entry.getKey();
            Mirage.getInstance().debug("Comparing broken " + String.valueOf(blockType1) + " with " + String.valueOf(blockType));
            if (!blockType1.equals(blockType)) {
                Mirage.getInstance().debug("Not a match.");
                continue;
            }
            Mirage.getInstance().debug("We have a match.");
            return Optional.of(entry);
        }
        Mirage.getInstance().debug("No matches found.");
        return Optional.empty();
    }

    public Optional<Map.Entry<BlockType, DataEntry>> match(BlockBreakEvent event) {
        Mirage.getInstance().debug("Attempting to find a match for " + String.valueOf(event.getBlock().getType()) + " with data value of " + event.getBlock().getData());
        return this.match(event.getBlock());
    }

    public RegenerationEntry addRegenerationEntry(Block block, Map.Entry<BlockType, DataEntry> entry, boolean runTask) {
        Validate.notNull((Object)block);
        Validate.notNull(entry);
        RegenerationEntry e = new RegenerationEntry(block.getLocation(), entry);
        this.regenerationEntries.add(e);
        Mirage.getInstance().debug("Will be regenerated at " + String.valueOf(new Date(e.getRegenTime())));
        if (runTask) {
            this.startRegenerationTask(e);
        }
        return e;
    }

    public boolean isRegenerating(Block block) {
        return this.regenerationEntries.stream().anyMatch(e -> e.getLocation().equals((Object)block.getLocation()));
    }

    public void loadRegenerationEntries() throws IOException {
        this.regenerationEntries.clear();
        if (!this.storageFile.exists()) {
            this.storageFile.createNewFile();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.storageFile);
        this.regenerationEntries.addAll(configuration.getMapList("data").stream().map(RegenerationEntry::new).collect(Collectors.toList()));
    }

    public void saveRegenerationEntries() throws IOException {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.storageFile);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RegenerationEntry regenerationEntry : this.regenerationEntries) {
            Map<String, Object> serialize = regenerationEntry.serialize();
            list.add(serialize);
        }
        configuration.set("data", list);
        configuration.save(this.storageFile);
        Mirage.getInstance().getLogger().info("Saved " + list.size() + " entries.");
    }

    public void startRegenerationTask(RegenerationEntry entry) {
        if (this.tasks.containsKey(entry.getLocation())) {
            return;
        }
        Mirage.getInstance().debug(entry.getLocation().toString() + " is gonna be regenerated in " + (entry.getRegenTime() - System.currentTimeMillis()) / 1000L + " seconds");
        this.tasks.put(entry.getLocation(), Bukkit.getScheduler().runTaskLater((Plugin)Mirage.getInstance(), entry::regenerate, (entry.getRegenTime() - System.currentTimeMillis()) / 1000L * 20L));
    }

    public void startRegenerationWatchdog() {
        if (this.watchdog != null) {
            throw new IllegalStateException("Watchdog already running");
        }
        this.watchdog = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Mirage.getInstance(), () -> this.regenerationEntries.stream().filter(RegenerationEntry::isOld).peek(e -> Mirage.getInstance().debug("Watchdog: " + (System.currentTimeMillis() - e.getRegenTime()) / 1000L)).filter(e -> (System.currentTimeMillis() - e.getRegenTime()) / 1000L < watchdogInterval).peek(e -> Mirage.getInstance().getLogger().info("Watchdog: " + String.valueOf(e.getLocation()))).forEach(this::startRegenerationTask), 0L, watchdogIntervalTicks.longValue());
    }

    public void stopRegenerationWatchdog() {
        if (this.watchdog == null) {
            throw new IllegalStateException("Watchdog is not running");
        }
        this.watchdog.cancel();
        this.watchdog = null;
    }

    public void checkChunkRegeneration(Chunk chunk) {
        this.regenerationEntries.stream().filter(e -> e.getLocation().getChunk().equals((Object)chunk)).filter(e -> System.currentTimeMillis() > e.getRegenTime()).forEach(this::startRegenerationTask);
    }

    @Generated
    public static ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    @Generated
    public Collection<RegenerationEntry> getRegenerationEntries() {
        return this.regenerationEntries;
    }

    @Generated
    public Map<Location, BukkitTask> getTasks() {
        return this.tasks;
    }

    @Generated
    public void setStorageFile(File storageFile) {
        this.storageFile = storageFile;
    }

    @Generated
    public BukkitTask getWatchdog() {
        return this.watchdog;
    }
}

