/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.reflection;

import java.lang.reflect.Method;
import me.filoghost.fcommons.reflection.ClassToken;
import me.filoghost.fcommons.reflection.InvalidReflectMethod;
import me.filoghost.fcommons.reflection.ReflectElement;
import me.filoghost.fcommons.reflection.ValidReflectMethod;

public interface ReflectMethod<T>
extends ReflectElement {
    public static <T> ReflectMethod<T> lookup(ClassToken<T> expectedReturnClassToken, Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        return ReflectMethod.lookup(expectedReturnClassToken.asClass(), declaringClass, name, parameterTypes);
    }

    public static <T> ReflectMethod<T> lookup(Class<T> expectedReturnClass, Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = declaringClass.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
        }
        catch (Throwable t) {
            return new InvalidReflectMethod(declaringClass, name, t);
        }
        return new ValidReflectMethod<T>(expectedReturnClass, method);
    }

    public T invoke(Object var1, Object ... var2) throws ReflectiveOperationException;

    public T invokeStatic(Object ... var1) throws ReflectiveOperationException;
}

