/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import me.filoghost.fcommons.reflection.ClassToken;
import me.filoghost.fcommons.reflection.InvalidReflectField;
import me.filoghost.fcommons.reflection.ReflectElement;
import me.filoghost.fcommons.reflection.ValidReflectField;

public interface ReflectField<T>
extends ReflectElement {
    public static <T> ReflectField<T> lookup(ClassToken<T> expectedClassToken, Class<?> declaringClass, String fieldName) {
        return ReflectField.lookup(expectedClassToken.asClass(), declaringClass, fieldName);
    }

    public static <T> ReflectField<T> lookup(Class<T> expectedClass, Class<?> declaringClass, String fieldName) {
        Field field;
        try {
            field = declaringClass.getDeclaredField(fieldName);
        }
        catch (Throwable t) {
            return new InvalidReflectField<T>(expectedClass, declaringClass, fieldName, t);
        }
        return ReflectField.wrap(expectedClass, field);
    }

    public static <T> ReflectField<T> lookup(Class<T> expectedClass, Class<?> declaringClass, int index) {
        Field[] fields = declaringClass.getDeclaredFields();
        int currentIndex = 0;
        for (Field field : fields) {
            if (expectedClass != field.getType() || currentIndex != index) continue;
            return ReflectField.wrap(expectedClass, field);
        }
        NoSuchFieldError e = new NoSuchFieldError("Could not find the field at index " + index + " of type " + expectedClass.getName());
        return new InvalidReflectField<T>(expectedClass, declaringClass, null, e);
    }

    public static ReflectField<?> wrap(Field field) {
        return ReflectField.wrap(field.getType(), field);
    }

    public static <T> ReflectField<T> wrap(ClassToken<T> expectedClassToken, Field field) {
        return ReflectField.wrap(expectedClassToken.asClass(), field);
    }

    public static <T> ReflectField<T> wrap(Class<T> expectedClass, Field field) {
        try {
            field.setAccessible(true);
        }
        catch (Throwable t) {
            return new InvalidReflectField<T>(expectedClass, field.getDeclaringClass(), field.getName(), t);
        }
        return new ValidReflectField<T>(expectedClass, field);
    }

    public Class<T> getExpectedClass();

    public Field getRawField() throws ReflectiveOperationException;

    public T get(Object var1) throws ReflectiveOperationException;

    public T getStatic() throws ReflectiveOperationException;

    public void set(Object var1, T var2) throws ReflectiveOperationException;

    public void setStatic(T var1) throws ReflectiveOperationException;

    public int getModifiers();

    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> var1);

    public Annotation[] getAnnotations();
}

