/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.ping;

import me.filoghost.fcommons.ping.PingParseException;
import net.md_5.bungee.chat.ComponentSerializer;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PingResponse {
    private final String motd;
    private final int onlinePlayers;
    private final int maxPlayers;

    private PingResponse(String motd, int onlinePlayers, int maxPlayers) {
        this.motd = motd;
        this.onlinePlayers = onlinePlayers;
        this.maxPlayers = maxPlayers;
    }

    static PingResponse fromJson(String jsonString) throws PingParseException {
        Object playersObject;
        String motd;
        if (jsonString.isEmpty()) {
            throw new PingParseException("empty", jsonString);
        }
        Object jsonObject = JSONValue.parse((String)jsonString);
        if (!(jsonObject instanceof JSONObject)) {
            throw new PingParseException("wrong format", jsonString);
        }
        JSONObject json = (JSONObject)jsonObject;
        Object descriptionObject = json.get((Object)"description");
        int onlinePlayers = 0;
        int maxPlayers = 0;
        if (descriptionObject == null) {
            throw new PingParseException("description not found", jsonString);
        }
        if (descriptionObject instanceof JSONObject) {
            String descriptionString = ((JSONObject)descriptionObject).toJSONString();
            try {
                motd = ComponentSerializer.parse((String)descriptionString)[0].toLegacyText();
            }
            catch (Exception e) {
                throw new PingParseException("could not parse description", jsonString);
            }
        } else {
            motd = descriptionObject.toString();
        }
        if ((playersObject = json.get((Object)"players")) instanceof JSONObject) {
            Object maxObject;
            JSONObject playersJson = (JSONObject)playersObject;
            Object onlineObject = playersJson.get((Object)"online");
            if (onlineObject instanceof Number) {
                onlinePlayers = ((Number)onlineObject).intValue();
            }
            if ((maxObject = playersJson.get((Object)"max")) instanceof Number) {
                maxPlayers = ((Number)maxObject).intValue();
            }
        }
        return new PingResponse(motd, onlinePlayers, maxPlayers);
    }

    public String getMotd() {
        return this.motd;
    }

    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }
}

