/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.ping;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import me.filoghost.fcommons.ping.PingParseException;
import me.filoghost.fcommons.ping.PingResponse;

public class MinecraftServerPinger {
    public static PingResponse ping(String serverAddress, int serverPort, int timeout) throws IOException, PingParseException {
        try (Socket socket = MinecraftServerPinger.openSocket(serverAddress, serverPort);){
            socket.setSoTimeout(timeout);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            ByteArrayOutputStream handshakeBytes = new ByteArrayOutputStream();
            DataOutputStream handshakeOut = new DataOutputStream(handshakeBytes);
            handshakeOut.writeByte(0);
            MinecraftServerPinger.writeVarInt(handshakeOut, 4);
            MinecraftServerPinger.writeString(handshakeOut, serverAddress);
            handshakeOut.writeShort(serverPort);
            MinecraftServerPinger.writeVarInt(handshakeOut, 1);
            MinecraftServerPinger.writeByteArray(out, handshakeBytes.toByteArray());
            MinecraftServerPinger.writeByteArray(out, new byte[]{0});
            MinecraftServerPinger.readVarInt(in);
            MinecraftServerPinger.readVarInt(in);
            String responseJson = MinecraftServerPinger.readString(in);
            PingResponse pingResponse = PingResponse.fromJson(responseJson);
            return pingResponse;
        }
    }

    private static Socket openSocket(String serverAddress, int serverPort) throws IOException {
        return new Socket(serverAddress, serverPort);
    }

    private static String readString(DataInputStream in) throws IOException {
        byte[] bytes = MinecraftServerPinger.readByteArray(in);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeString(DataOutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        MinecraftServerPinger.writeByteArray(out, bytes);
    }

    private static byte[] readByteArray(DataInputStream in) throws IOException {
        int length = MinecraftServerPinger.readVarInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return bytes;
    }

    private static void writeByteArray(DataOutputStream out, byte[] bytes) throws IOException {
        MinecraftServerPinger.writeVarInt(out, bytes.length);
        out.write(bytes);
    }

    private static int readVarInt(DataInputStream in) throws IOException {
        byte k;
        int i = 0;
        int j = 0;
        do {
            k = in.readByte();
            i |= (k & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((k & 0x80) == 128);
        return i;
    }

    private static void writeVarInt(DataOutputStream out, int paramInt) throws IOException {
        while ((paramInt & 0xFFFFFF80) != 0) {
            out.writeByte(paramInt & 0x7F | 0x80);
            paramInt >>>= 7;
        }
        out.writeByte(paramInt);
    }
}

