/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config.types;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.fcommons.config.ConfigType;
import me.filoghost.fcommons.config.ConfigValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedListConfigType
extends ConfigType<List<ConfigValue>> {
    public WrappedListConfigType(String name) {
        super(name, "value is not a list");
    }

    @Override
    protected boolean isConvertibleRawValue(@Nullable Object rawValue) {
        return rawValue instanceof List;
    }

    @Override
    @NotNull
    protected List<ConfigValue> fromRawValue(@NotNull Object rawValue) {
        ArrayList<ConfigValue> configValue = new ArrayList<ConfigValue>();
        for (Object element : (List)rawValue) {
            configValue.add(WrappedListConfigType.wrapRawValue(element));
        }
        return configValue;
    }

    @Override
    @NotNull
    protected Object toRawValue(@NotNull List<ConfigValue> configValue) {
        ArrayList<Object> rawValue = new ArrayList<Object>();
        for (ConfigValue element : configValue) {
            rawValue.add(WrappedListConfigType.getRawValue(element));
        }
        return rawValue;
    }
}

