/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config.mapped;

import java.nio.file.Path;
import java.util.Map;
import me.filoghost.fcommons.config.Config;
import me.filoghost.fcommons.config.ConfigLoader;
import me.filoghost.fcommons.config.ConfigPath;
import me.filoghost.fcommons.config.ConfigSection;
import me.filoghost.fcommons.config.ConfigValue;
import me.filoghost.fcommons.config.FileConfig;
import me.filoghost.fcommons.config.exception.ConfigLoadException;
import me.filoghost.fcommons.config.exception.ConfigMappingException;
import me.filoghost.fcommons.config.exception.ConfigSaveException;
import me.filoghost.fcommons.config.exception.ConfigValueException;
import me.filoghost.fcommons.config.mapped.ConfigMapper;
import me.filoghost.fcommons.config.mapped.MappedConfig;
import me.filoghost.fcommons.reflection.TypeInfo;
import org.jetbrains.annotations.NotNull;

public class MappedConfigLoader<T extends MappedConfig> {
    private final TypeInfo<T> mappedTypeInfo;
    private ConfigMapper<T> configMapper;
    private final ConfigLoader configLoader;
    private Map<ConfigPath, ConfigValue> defaultValues;

    public MappedConfigLoader(Path rootDataFolder, Path configPath, Class<T> mappedConfigClass) {
        this.mappedTypeInfo = TypeInfo.of(mappedConfigClass);
        this.configLoader = new ConfigLoader(rootDataFolder, configPath);
    }

    protected ConfigMapper<T> getMapper() throws ConfigMappingException {
        if (this.configMapper == null) {
            this.configMapper = new ConfigMapper<T>(this.mappedTypeInfo);
        }
        return this.configMapper;
    }

    @NotNull
    public T load() throws ConfigLoadException {
        FileConfig config = this.configLoader.load();
        try {
            MappedConfig mappedObject = (MappedConfig)this.getMapper().newMappedObjectInstance();
            mappedObject.beforeLoad(config);
            this.getMapper().setFieldsFromConfig(mappedObject, config);
            return (T)mappedObject;
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e);
        }
        catch (ConfigValueException e) {
            throw new ConfigLoadException("Invalid \"" + e.getConfigPath() + "\", " + e.getMessage());
        }
    }

    @NotNull
    public T init() throws ConfigLoadException, ConfigSaveException {
        FileConfig config = this.configLoader.init();
        try {
            MappedConfig mappedObject = (MappedConfig)this.getMapper().newMappedObjectInstance();
            boolean modifiedBeforeLoad = mappedObject.beforeLoad(config);
            if (this.defaultValues == null) {
                this.defaultValues = this.getMapper().getFieldsAsConfigValues(mappedObject);
            }
            boolean addedNewDefaultValues = this.addMissingDefaultValues(config, this.defaultValues);
            this.getMapper().setFieldsFromConfig(mappedObject, config);
            if (modifiedBeforeLoad || addedNewDefaultValues) {
                this.saveInternal(mappedObject, config, false);
            }
            return (T)mappedObject;
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e);
        }
        catch (ConfigValueException e) {
            throw new ConfigLoadException("Invalid \"" + e.getConfigPath() + "\", " + e.getMessage());
        }
    }

    private boolean addMissingDefaultValues(ConfigSection config, Map<ConfigPath, ConfigValue> defaultValues) {
        boolean modified = false;
        for (Map.Entry<ConfigPath, ConfigValue> entry : defaultValues.entrySet()) {
            if (config.contains(entry.getKey())) continue;
            config.set(entry.getKey(), entry.getValue());
            modified = true;
        }
        return modified;
    }

    public boolean saveIfDifferent(@NotNull T newMappedObject) throws ConfigLoadException, ConfigSaveException {
        if (!this.configLoader.fileExists()) {
            this.save(newMappedObject);
            return true;
        }
        FileConfig config = this.configLoader.load();
        try {
            if (this.getMapper().equalsConfig(newMappedObject, config)) {
                return false;
            }
            this.saveInternal(newMappedObject, config, true);
            return true;
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e);
        }
    }

    public void save(@NotNull T mappedObject) throws ConfigSaveException {
        this.saveInternal(mappedObject, new Config(), true);
    }

    private void saveInternal(@NotNull T mappedObject, @NotNull Config config, boolean writeMappedObject) throws ConfigSaveException {
        if (writeMappedObject) {
            try {
                this.getMapper().setConfigFromFields(mappedObject, config);
            }
            catch (ConfigMappingException e) {
                throw new ConfigSaveException(e.getMessage(), e);
            }
        }
        config.setHeader(mappedObject.getHeader());
        this.configLoader.save(config);
    }

    public Path getFile() {
        return this.configLoader.getFile();
    }
}

