/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config.mapped;

import com.google.common.collect.Lists;
import java.util.List;
import me.filoghost.fcommons.config.ConfigSection;
import me.filoghost.fcommons.config.ConfigType;
import me.filoghost.fcommons.config.exception.ConfigMappingException;
import me.filoghost.fcommons.config.mapped.converter.ConfigTypeConverter;
import me.filoghost.fcommons.config.mapped.converter.Converter;
import me.filoghost.fcommons.config.mapped.converter.ListConverter;
import me.filoghost.fcommons.config.mapped.converter.MappedConfigSectionConverter;
import me.filoghost.fcommons.reflection.TypeInfo;
import org.jetbrains.annotations.NotNull;

public class ConverterRegistry {
    private static final List<ConfigTypeConverter<?>> CONFIG_VALUE_TYPE_CONVERTERS = Lists.newArrayList((Object[])new ConfigTypeConverter[]{new ConfigTypeConverter<Double>(ConfigType.DOUBLE, Double.class, Double.TYPE), new ConfigTypeConverter<Float>(ConfigType.FLOAT, Float.class, Float.TYPE), new ConfigTypeConverter<Long>(ConfigType.LONG, Long.class, Long.TYPE), new ConfigTypeConverter<Integer>(ConfigType.INTEGER, Integer.class, Integer.TYPE), new ConfigTypeConverter<Short>(ConfigType.SHORT, Short.class, Short.TYPE), new ConfigTypeConverter<Byte>(ConfigType.BYTE, Byte.class, Byte.TYPE), new ConfigTypeConverter<Boolean>(ConfigType.BOOLEAN, Boolean.class, Boolean.TYPE), new ConfigTypeConverter<String>(ConfigType.STRING, String.class), new ConfigTypeConverter<ConfigSection>(ConfigType.SECTION, ConfigSection.class)});

    @NotNull
    public static <T> Converter<T, ?> fromObjectType(TypeInfo<T> typeInfo) throws ConfigMappingException {
        Class typeClass = typeInfo.getTypeClass();
        if (typeClass != null) {
            for (ConfigTypeConverter configTypeConverter : CONFIG_VALUE_TYPE_CONVERTERS) {
                if (!configTypeConverter.supports(typeClass)) continue;
                return configTypeConverter;
            }
            if (MappedConfigSectionConverter.supports(typeClass)) {
                return new MappedConfigSectionConverter(typeInfo);
            }
            if (ListConverter.supports(typeClass)) {
                return new ListConverter(typeInfo);
            }
        }
        throw new ConfigMappingException("cannot find suitable converter for type \"" + typeInfo + "\"");
    }
}

