/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config;

import java.util.List;
import me.filoghost.fcommons.config.ConfigPath;
import me.filoghost.fcommons.config.ConfigSection;
import me.filoghost.fcommons.config.ConfigValue;
import me.filoghost.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.fcommons.config.exception.MissingConfigValueException;
import me.filoghost.fcommons.config.types.BooleanConfigType;
import me.filoghost.fcommons.config.types.ListConfigType;
import me.filoghost.fcommons.config.types.NumberConfigType;
import me.filoghost.fcommons.config.types.SectionConfigType;
import me.filoghost.fcommons.config.types.StringConfigType;
import me.filoghost.fcommons.config.types.WrappedListConfigType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigType<T> {
    public static final ConfigType<String> STRING = new StringConfigType("STRING");
    public static final ConfigType<Boolean> BOOLEAN = new BooleanConfigType("BOOLEAN");
    public static final ConfigType<Long> LONG = new NumberConfigType<Long>("LONG", Number::longValue);
    public static final ConfigType<Integer> INTEGER = new NumberConfigType<Integer>("INTEGER", Number::intValue);
    public static final ConfigType<Short> SHORT = new NumberConfigType<Short>("SHORT", Number::shortValue);
    public static final ConfigType<Byte> BYTE = new NumberConfigType<Byte>("BYTE", Number::byteValue);
    public static final ConfigType<Double> DOUBLE = new NumberConfigType<Double>("DOUBLE", Number::doubleValue);
    public static final ConfigType<Float> FLOAT = new NumberConfigType<Float>("FLOAT", Number::floatValue);
    public static final ConfigType<ConfigSection> SECTION = new SectionConfigType("SECTION");
    public static final ConfigType<List<ConfigValue>> LIST = new WrappedListConfigType("LIST");
    public static final ConfigType<List<String>> STRING_LIST = new ListConfigType<String>("STRING_LIST", STRING);
    public static final ConfigType<List<Integer>> INTEGER_LIST = new ListConfigType<Integer>("INTEGER_LIST", INTEGER);
    public static final ConfigType<List<ConfigSection>> SECTION_LIST = new ListConfigType<ConfigSection>("SECTION_LIST", SECTION);
    private final String name;
    private final String notConvertibleErrorMessage;

    protected ConfigType(String name, String notConvertibleErrorMessage) {
        this.name = name;
        this.notConvertibleErrorMessage = notConvertibleErrorMessage;
    }

    @Contract(value="null -> false")
    protected abstract boolean isConvertibleRawValue(@Nullable Object var1);

    @NotNull
    protected abstract Object toRawValue(@NotNull T var1);

    @NotNull
    protected abstract T fromRawValue(@NotNull Object var1);

    @Nullable
    protected T fromRawValueOrNull(@Nullable Object rawValue) {
        return this.fromRawValueOrDefault(rawValue, null);
    }

    @Contract(value="_, !null -> !null")
    protected T fromRawValueOrDefault(@Nullable Object rawValue, T defaultValue) {
        if (this.isConvertibleRawValue(rawValue)) {
            return this.fromRawValue(rawValue);
        }
        return defaultValue;
    }

    @NotNull
    protected T fromRawValueRequired(@Nullable Object rawValue, @Nullable ConfigPath configPath) throws InvalidConfigValueException, MissingConfigValueException {
        if (this.isConvertibleRawValue(rawValue)) {
            return this.fromRawValue(rawValue);
        }
        if (rawValue != null) {
            throw new InvalidConfigValueException(configPath, this.notConvertibleErrorMessage);
        }
        throw new MissingConfigValueException(configPath, "value is missing");
    }

    protected static ConfigValue wrapRawValue(@Nullable Object rawValue) {
        return ConfigValue.wrapRawValue(null, rawValue);
    }

    protected static Object getRawValue(@NotNull ConfigValue configValue) {
        return configValue.getRawValue();
    }

    protected static <T> Object toRawValue(@NotNull ConfigType<T> type, @NotNull T configValue) {
        return type.toRawValue(configValue);
    }

    protected static <T> T fromRawValueOrNull(@NotNull ConfigType<T> type, @Nullable Object rawValue) {
        return type.fromRawValueOrNull(rawValue);
    }

    public String toString() {
        return this.name;
    }
}

