/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.filoghost.fcommons.config.BaseConfigSection;
import me.filoghost.fcommons.config.ConfigPath;
import me.filoghost.fcommons.config.ConfigType;
import me.filoghost.fcommons.config.ConfigValue;
import me.filoghost.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.fcommons.config.exception.MissingConfigValueException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigSection
extends BaseConfigSection {
    public ConfigSection() {
        super(new LinkedHashMap<String, Object>());
    }

    protected ConfigSection(LinkedHashMap<String, Object> rawValues) {
        super(rawValues);
    }

    public ConfigValue get(String path) {
        return this.get(ConfigPath.dotDelimited(path));
    }

    public <T> T get(String path, @NotNull ConfigType<T> configType) {
        return (T)this.get(ConfigPath.dotDelimited(path), (ConfigType)configType);
    }

    public <T> T getOrDefault(String path, @NotNull ConfigType<T> configType, @Nullable T defaultValue) {
        return (T)this.getOrDefault(ConfigPath.dotDelimited(path), (ConfigType)configType, (Object)defaultValue);
    }

    public <T> T getRequired(String path, @NotNull ConfigType<T> configType) throws MissingConfigValueException, InvalidConfigValueException {
        return (T)this.getRequired(ConfigPath.dotDelimited(path), (ConfigType)configType);
    }

    public void set(String path, @NotNull ConfigValue configValue) {
        this.set(ConfigPath.dotDelimited(path), configValue);
    }

    public <T> void set(String path, @NotNull ConfigType<T> configType, @Nullable T value) {
        this.set(ConfigPath.dotDelimited(path), (ConfigType)configType, (Object)value);
    }

    public boolean contains(String path) {
        return this.contains(ConfigPath.dotDelimited(path));
    }

    public void remove(String path) {
        this.remove(ConfigPath.dotDelimited(path));
    }

    public Map<ConfigPath, ConfigValue> toMap() {
        LinkedHashMap<ConfigPath, ConfigValue> map = new LinkedHashMap<ConfigPath, ConfigValue>();
        for (Map.Entry<String, Object> entry : this.getRawValues().entrySet()) {
            ConfigPath path = ConfigPath.literal(entry.getKey());
            ConfigValue value = ConfigValue.wrapRawValue(path, entry.getValue());
            map.put(path, value);
        }
        return map;
    }

    public <T> Map<ConfigPath, T> toMap(ConfigType<T> valueTypeFilter) {
        LinkedHashMap<ConfigPath, T> map = new LinkedHashMap<ConfigPath, T>();
        for (Map.Entry<String, Object> entry : this.getRawValues().entrySet()) {
            ConfigPath path = ConfigPath.literal(entry.getKey());
            T value = valueTypeFilter.fromRawValueOrNull(entry.getValue());
            if (value == null) continue;
            map.put(path, value);
        }
        return map;
    }

    public ConfigSection getOrCreateSection(String path) {
        ConfigPath configPath = ConfigPath.dotDelimited(path);
        ConfigSection section = this.getConfigSection(configPath);
        if (section == null) {
            section = new ConfigSection();
            this.setConfigSection(configPath, section);
        }
        return section;
    }

    public String getString(ConfigPath path) {
        return (String)this.getOrDefault(path, (ConfigType)ConfigType.STRING, (Object)null);
    }

    public String getString(String path) {
        return this.getString(ConfigPath.dotDelimited(path));
    }

    public String getString(ConfigPath path, String defaultValue) {
        return (String)this.getOrDefault(path, (ConfigType)ConfigType.STRING, defaultValue);
    }

    public String getString(String path, String defaultValue) {
        return this.getString(ConfigPath.dotDelimited(path), defaultValue);
    }

    public String getRequiredString(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (String)this.getRequired(path, (ConfigType)ConfigType.STRING);
    }

    public String getRequiredString(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredString(ConfigPath.dotDelimited(path));
    }

    public void setString(ConfigPath path, String value) {
        this.set(path, (ConfigType)ConfigType.STRING, value);
    }

    public void setString(String path, String value) {
        this.setString(ConfigPath.dotDelimited(path), value);
    }

    public boolean getBoolean(ConfigPath path) {
        return (Boolean)this.getOrDefault(path, (ConfigType)ConfigType.BOOLEAN, (Object)false);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(ConfigPath.dotDelimited(path));
    }

    public boolean getBoolean(ConfigPath path, boolean defaultValue) {
        return (Boolean)this.getOrDefault(path, (ConfigType)ConfigType.BOOLEAN, (Object)defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.getBoolean(ConfigPath.dotDelimited(path), defaultValue);
    }

    public boolean getRequiredBoolean(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (Boolean)this.getRequired(path, (ConfigType)ConfigType.BOOLEAN);
    }

    public boolean getRequiredBoolean(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredBoolean(ConfigPath.dotDelimited(path));
    }

    public void setBoolean(ConfigPath path, boolean value) {
        this.set(path, (ConfigType)ConfigType.BOOLEAN, (Object)value);
    }

    public void setBoolean(String path, boolean value) {
        this.setBoolean(ConfigPath.dotDelimited(path), value);
    }

    public int getInt(ConfigPath path) {
        return (Integer)this.getOrDefault(path, (ConfigType)ConfigType.INTEGER, (Object)0);
    }

    public int getInt(String path) {
        return this.getInt(ConfigPath.dotDelimited(path));
    }

    public int getInt(ConfigPath path, int defaultValue) {
        return (Integer)this.getOrDefault(path, (ConfigType)ConfigType.INTEGER, (Object)defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.getInt(ConfigPath.dotDelimited(path), defaultValue);
    }

    public int getRequiredInt(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (Integer)this.getRequired(path, (ConfigType)ConfigType.INTEGER);
    }

    public int getRequiredInt(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredInt(ConfigPath.dotDelimited(path));
    }

    public void setInt(ConfigPath path, int value) {
        this.set(path, (ConfigType)ConfigType.INTEGER, (Object)value);
    }

    public void setInt(String path, int value) {
        this.setInt(ConfigPath.dotDelimited(path), value);
    }

    public double getDouble(ConfigPath path) {
        return (Double)this.getOrDefault(path, (ConfigType)ConfigType.DOUBLE, (Object)0.0);
    }

    public double getDouble(String path) {
        return this.getDouble(ConfigPath.dotDelimited(path));
    }

    public double getDouble(ConfigPath path, double defaultValue) {
        return (Double)this.getOrDefault(path, (ConfigType)ConfigType.DOUBLE, (Object)defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.getDouble(ConfigPath.dotDelimited(path), defaultValue);
    }

    public double getRequiredDouble(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (Double)this.getRequired(path, (ConfigType)ConfigType.DOUBLE);
    }

    public double getRequiredDouble(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredDouble(ConfigPath.dotDelimited(path));
    }

    public void setDouble(ConfigPath path, double value) {
        this.set(path, (ConfigType)ConfigType.DOUBLE, (Object)value);
    }

    public void setDouble(String path, double value) {
        this.setDouble(ConfigPath.dotDelimited(path), value);
    }

    public ConfigSection getConfigSection(ConfigPath path) {
        return (ConfigSection)this.getOrDefault(path, (ConfigType)ConfigType.SECTION, (Object)null);
    }

    public ConfigSection getConfigSection(String path) {
        return this.getConfigSection(ConfigPath.dotDelimited(path));
    }

    public ConfigSection getConfigSection(ConfigPath path, ConfigSection defaultValue) {
        return (ConfigSection)this.getOrDefault(path, (ConfigType)ConfigType.SECTION, defaultValue);
    }

    public ConfigSection getConfigSection(String path, ConfigSection defaultValue) {
        return this.getConfigSection(ConfigPath.dotDelimited(path), defaultValue);
    }

    public ConfigSection getRequiredConfigSection(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (ConfigSection)this.getRequired(path, (ConfigType)ConfigType.SECTION);
    }

    public ConfigSection getRequiredConfigSection(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredConfigSection(ConfigPath.dotDelimited(path));
    }

    public void setConfigSection(ConfigPath path, ConfigSection value) {
        this.set(path, (ConfigType)ConfigType.SECTION, value);
    }

    public void setConfigSection(String path, ConfigSection value) {
        this.setConfigSection(ConfigPath.dotDelimited(path), value);
    }

    public List<String> getStringList(ConfigPath path) {
        return (List)this.getOrDefault(path, (ConfigType)ConfigType.STRING_LIST, (Object)null);
    }

    public List<String> getStringList(String path) {
        return this.getStringList(ConfigPath.dotDelimited(path));
    }

    public List<String> getStringList(ConfigPath path, List<String> defaultValue) {
        return (List)this.getOrDefault(path, (ConfigType)ConfigType.STRING_LIST, defaultValue);
    }

    public List<String> getStringList(String path, List<String> defaultValue) {
        return this.getStringList(ConfigPath.dotDelimited(path), defaultValue);
    }

    public List<String> getRequiredStringList(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (List)this.getRequired(path, (ConfigType)ConfigType.STRING_LIST);
    }

    public List<String> getRequiredStringList(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredStringList(ConfigPath.dotDelimited(path));
    }

    public void setStringList(ConfigPath path, List<String> value) {
        this.set(path, (ConfigType)ConfigType.STRING_LIST, value);
    }

    public void setStringList(String path, List<String> value) {
        this.setStringList(ConfigPath.dotDelimited(path), value);
    }

    public List<ConfigSection> getSectionList(ConfigPath path) {
        return (List)this.getOrDefault(path, (ConfigType)ConfigType.SECTION_LIST, (Object)null);
    }

    public List<ConfigSection> getSectionList(String path) {
        return this.getSectionList(ConfigPath.dotDelimited(path));
    }

    public List<ConfigSection> getSectionList(ConfigPath path, List<ConfigSection> defaultValue) {
        return (List)this.getOrDefault(path, (ConfigType)ConfigType.SECTION_LIST, defaultValue);
    }

    public List<ConfigSection> getSectionList(String path, List<ConfigSection> defaultValue) {
        return this.getSectionList(ConfigPath.dotDelimited(path), defaultValue);
    }

    public List<ConfigSection> getRequiredSectionList(ConfigPath path) throws MissingConfigValueException, InvalidConfigValueException {
        return (List)this.getRequired(path, (ConfigType)ConfigType.SECTION_LIST);
    }

    public List<ConfigSection> getRequiredSectionList(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequiredSectionList(ConfigPath.dotDelimited(path));
    }

    public void setSectionList(ConfigPath path, List<ConfigSection> value) {
        this.set(path, (ConfigType)ConfigType.SECTION_LIST, value);
    }

    public void setSectionList(String path, List<ConfigSection> value) {
        this.setSectionList(ConfigPath.dotDelimited(path), value);
    }
}

