/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config;

import com.google.common.collect.ImmutableList;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.fcommons.Strings;

public final class ConfigPath {
    private final ImmutableList<String> parts;

    private ConfigPath(ImmutableList<String> parts) {
        this.parts = parts;
    }

    public static ConfigPath dotDelimited(String delimitedPath) {
        return ConfigPath.delimitedBy(delimitedPath, ".");
    }

    public static ConfigPath delimitedBy(String delimitedPath, String delimiter) {
        Preconditions.notEmpty(delimitedPath, "delimitedPath");
        return ConfigPath.literal(Strings.split(delimitedPath, delimiter));
    }

    public static ConfigPath literal(String path) {
        Preconditions.notEmpty(path, "path");
        return new ConfigPath((ImmutableList<String>)ImmutableList.of((Object)path));
    }

    public static ConfigPath literal(String ... parts) {
        Preconditions.notEmpty(parts, "parts");
        for (String part : parts) {
            Preconditions.notEmpty(part, "parts element");
        }
        return new ConfigPath((ImmutableList<String>)ImmutableList.copyOf((Object[])parts));
    }

    public int getPartsLength() {
        return this.parts.size();
    }

    public String getPart(int index) {
        return (String)this.parts.get(index);
    }

    public String getLastPart() {
        return (String)this.parts.get(this.parts.size() - 1);
    }

    public String asRawKey() {
        Preconditions.checkState(this.getPartsLength() == 1, "must contain a single part");
        return this.getPart(0);
    }

    public ConfigPath replace(String target, String replacement) {
        ImmutableList.Builder pathPartsBuilder = ImmutableList.builder();
        for (String pathPart : this.parts) {
            pathPartsBuilder.add((Object)pathPart.replace(target, replacement));
        }
        return new ConfigPath((ImmutableList<String>)pathPartsBuilder.build());
    }

    public String format(String delimiter) {
        return String.join((CharSequence)delimiter, this.parts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigPath other = (ConfigPath)obj;
        return this.parts.equals(other.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public String toString() {
        return this.format(" > ");
    }
}

