/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.fcommons.config.ConfigSection;
import me.filoghost.fcommons.config.YamlSerializer;
import me.filoghost.fcommons.config.exception.ConfigLoadException;

public class Config
extends ConfigSection {
    private final YamlSerializer yamlSerializer = new YamlSerializer();
    private List<String> header;

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(String ... header) {
        this.setHeader(Arrays.asList(header));
    }

    public void setHeader(List<String> header) {
        this.header = ImmutableList.copyOf(header);
    }

    protected void loadFromString(List<String> fileContents) throws ConfigLoadException {
        Preconditions.notNull(fileContents, "fileContents cannot be null");
        LinkedHashMap<String, Object> rawValues = this.yamlSerializer.parseRawValues(fileContents);
        if (rawValues == null) {
            rawValues = new LinkedHashMap();
        }
        this.setHeader(this.yamlSerializer.parseHeader(fileContents));
        this.setRawValues(rawValues);
    }

    protected String saveToString() {
        String serializedHeader = this.yamlSerializer.serializeHeader(this.header);
        String serializedValues = this.yamlSerializer.serializeConfigValues(this.getRawValues());
        return serializedHeader + serializedValues;
    }
}

