/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.config;

import java.nio.file.Path;
import me.filoghost.fcommons.config.ConfigLoader;
import me.filoghost.fcommons.config.mapped.MappedConfig;
import me.filoghost.fcommons.config.mapped.MappedConfigLoader;

public class BaseConfigManager {
    protected final Path rootDataFolder;

    public BaseConfigManager(Path rootDataFolder) {
        this.rootDataFolder = rootDataFolder;
    }

    public Path getRootDataFolder() {
        return this.rootDataFolder;
    }

    public ConfigLoader getConfigLoader(String fileName) {
        return this.getConfigLoader(this.rootDataFolder.resolve(fileName));
    }

    public ConfigLoader getConfigLoader(Path configPath) {
        return new ConfigLoader(this.rootDataFolder, configPath);
    }

    public <T extends MappedConfig> MappedConfigLoader<T> getMappedConfigLoader(String fileName, Class<T> mappedConfigClass) {
        return this.getMappedConfigLoader(this.rootDataFolder.resolve(fileName), mappedConfigClass);
    }

    public <T extends MappedConfig> MappedConfigLoader<T> getMappedConfigLoader(Path configPath, Class<T> mappedConfigClass) {
        return new MappedConfigLoader<T>(this.rootDataFolder, configPath, mappedConfigClass);
    }
}

