/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.command.sub;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.fcommons.command.CommandContext;
import me.filoghost.fcommons.command.CommandHelper;
import me.filoghost.fcommons.command.ConfigurableRootCommand;
import me.filoghost.fcommons.command.sub.SubCommand;
import me.filoghost.fcommons.command.sub.SubCommandContext;
import me.filoghost.fcommons.command.validation.CommandException;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public abstract class SubCommandManager
extends ConfigurableRootCommand {
    protected abstract SubCommand getSubCommandByName(String var1);

    protected abstract Iterable<? extends SubCommand> getSubCommands();

    @Override
    public final void execute(CommandSender sender, String[] args, CommandContext context) throws CommandException {
        if (args.length == 0) {
            this.sendNoArgsMessage(context);
            return;
        }
        String subLabel = args[0];
        SubCommand subCommand = this.getSubCommandByName(subLabel);
        String[] subCommandArgs = CommandHelper.getArgsFromIndex(args, 1);
        SubCommandContext subContext = new SubCommandContext(context.getSender(), context.getRootLabel(), subCommandArgs, subCommand, subLabel);
        if (subCommand == null) {
            this.sendUnknownSubCommandMessage(subContext);
            return;
        }
        if (!subCommand.hasPermission((Permissible)sender)) {
            if (subCommand.getPermissionMessage() != null) {
                sender.sendMessage(subCommand.getPermissionMessage());
            } else {
                this.sendSubCommandDefaultPermissionMessage(subContext);
            }
            return;
        }
        if (subCommandArgs.length < subCommand.getMinArgs()) {
            this.sendSubCommandUsage(subContext);
            return;
        }
        subCommand.execute(subContext.getSender(), subContext.getArgs(), subContext);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommandNames = new ArrayList<String>();
            for (SubCommand subCommand : this.getAccessibleSubCommands((Permissible)sender)) {
                subCommandNames.add(subCommand.getName());
            }
            return CommandHelper.filterStartingWith(args[0], subCommandNames);
        }
        SubCommand subCommand = this.getSubCommandByName(args[0]);
        if (subCommand != null) {
            return subCommand.onTabComplete(sender, command, alias, CommandHelper.getArgsFromIndex(args, 1));
        }
        return new ArrayList<String>();
    }

    protected Iterable<? extends SubCommand> getAccessibleSubCommands(Permissible sender) {
        ArrayList<SubCommand> list = new ArrayList<SubCommand>();
        for (SubCommand subCommand : this.getSubCommands()) {
            if (!subCommand.hasPermission(sender)) continue;
            list.add(subCommand);
        }
        return list;
    }

    protected void sendSubCommandUsage(SubCommandContext context) {
        String usageText = this.getUsageText(context, context.getSubCommand());
        context.getSender().sendMessage(ChatColor.RED + "Command usage: " + usageText);
    }

    protected void sendSubCommandDefaultPermissionMessage(SubCommandContext context) {
        context.getSender().sendMessage(ChatColor.RED + "You don't have permission for this sub-command.");
    }

    protected void sendUnknownSubCommandMessage(SubCommandContext context) {
        context.getSender().sendMessage(ChatColor.RED + "Unknown sub-command \"" + context.getSubLabel() + "\". Use /" + context.getRootLabel() + " to see available commands.");
    }

    protected void sendNoArgsMessage(CommandContext context) {
        CommandSender sender = context.getSender();
        sender.sendMessage(ChatColor.WHITE + "/" + context.getRootLabel() + " commands:");
        for (SubCommand subCommand : this.getAccessibleSubCommands((Permissible)sender)) {
            sender.sendMessage(ChatColor.GRAY + this.getUsageText(context, subCommand));
        }
    }

    protected String getUsageText(CommandContext context, SubCommand subCommand) {
        String rootLabel = context.getRootLabel();
        String usageArgs = subCommand.getUsageArgs();
        return "/" + rootLabel + " " + subCommand.getName() + (usageArgs != null ? " " + usageArgs : "");
    }
}

