/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.command;

import java.util.List;
import java.util.logging.Level;
import me.filoghost.fcommons.command.CommandContext;
import me.filoghost.fcommons.command.ConfigurableCommandProperties;
import me.filoghost.fcommons.command.RootCommand;
import me.filoghost.fcommons.command.validation.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class ConfigurableRootCommand
extends ConfigurableCommandProperties
implements RootCommand {
    public final boolean register(JavaPlugin plugin) {
        super.validate();
        PluginCommand pluginCommand = plugin.getCommand(this.getName());
        if (pluginCommand == null) {
            return false;
        }
        if (this.getPermission() != null) {
            pluginCommand.setPermission(this.getPermission());
        }
        if (this.getPermissionMessage() != null) {
            pluginCommand.setPermissionMessage(this.getPermissionMessage());
        } else {
            pluginCommand.setPermissionMessage(ChatColor.RED + "You don't have permission for this command.");
        }
        BukkitCommandExecutorAdapter executor = new BukkitCommandExecutorAdapter(this);
        pluginCommand.setExecutor((CommandExecutor)executor);
        pluginCommand.setTabCompleter((TabCompleter)executor);
        return true;
    }

    protected void handleUnexpectedException(CommandContext context, Throwable t) {
        Bukkit.getLogger().log(Level.SEVERE, "Internal error while executing /" + context.getRootLabel(), t);
        context.getSender().sendMessage(ChatColor.RED + "Internal error while executing command.");
    }

    protected void sendExecutionErrorMessage(CommandContext context, String errorMessage) {
        context.getSender().sendMessage(ChatColor.RED + errorMessage);
    }

    private static class BukkitCommandExecutorAdapter
    implements CommandExecutor,
    TabCompleter {
        private final ConfigurableRootCommand command;

        private BukkitCommandExecutorAdapter(ConfigurableRootCommand command) {
            this.command = command;
        }

        public final boolean onCommand(CommandSender sender, Command bukkitCommand, String label, String[] args) {
            CommandContext context = new CommandContext(sender, label, args);
            try {
                this.command.execute(context.getSender(), context.getArgs(), context);
            }
            catch (CommandException ex) {
                this.command.sendExecutionErrorMessage(context, ex.getMessage());
            }
            catch (Throwable t) {
                this.command.handleUnexpectedException(context, t);
            }
            return true;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            return this.command.onTabComplete(sender, command, alias, args);
        }
    }
}

