/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.collection;

import java.util.Arrays;
import java.util.function.Function;
import me.filoghost.fcommons.Strings;
import me.filoghost.fcommons.collection.CaseInsensitiveHashMap;
import me.filoghost.fcommons.collection.CaseInsensitiveMap;
import org.jetbrains.annotations.Nullable;

public class LookupRegistry<V> {
    private static final char[] KEY_IGNORE_CHARS = new char[]{'-', '_', ' '};
    private final CaseInsensitiveMap<V> valuesMap = new CaseInsensitiveHashMap();

    public static <V> LookupRegistry<V> fromValues(V[] values, Function<V, String> keyExtractor) {
        return LookupRegistry.fromValues(Arrays.asList(values), keyExtractor);
    }

    public static <V> LookupRegistry<V> fromValues(Iterable<V> values, Function<V, String> keyExtractor) {
        LookupRegistry<V> registry = new LookupRegistry<V>();
        registry.putAll(values, keyExtractor);
        return registry;
    }

    protected LookupRegistry() {
    }

    @Nullable
    public V lookup(String key) {
        if (key == null) {
            return null;
        }
        return this.valuesMap.get(this.removeIgnoredChars(key));
    }

    protected void putAll(Iterable<V> values, Function<V, String> keyExtractor) {
        for (V value : values) {
            this.put(keyExtractor.apply(value), value);
        }
    }

    public void put(String key, V value) {
        this.valuesMap.put(this.removeIgnoredChars(key), value);
    }

    private String removeIgnoredChars(String valueName) {
        return Strings.stripChars(valueName, KEY_IGNORE_CHARS);
    }

    public String toString() {
        return "LookupRegistry [values=" + this.valuesMap + "]";
    }
}

