/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.collection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    @Contract(value="null -> null; !null -> !null")
    public static <E> List<E> newArrayList(@Nullable Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<E>(collection);
    }

    @Contract(value="null -> null; !null -> !null")
    public static <E> Set<E> newHashSet(@Nullable Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        return new HashSet<E>(collection);
    }

    @Contract(value="null -> null; !null -> !null")
    public static <K, V> Map<K, V> newHashMap(@Nullable Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new HashMap<K, V>(map);
    }

    @Contract(value="null -> null; !null -> !null")
    public static <E> ImmutableList<E> newImmutableList(@Nullable Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        return ImmutableList.copyOf(collection);
    }

    @Contract(value="null -> null; !null -> !null")
    public static <E> ImmutableSet<E> newImmutableSet(@Nullable Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        return ImmutableSet.copyOf(collection);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <A, B> List<B> toArrayList(@Nullable Collection<A> collection, @NotNull Function<A, B> transformFunction) {
        if (collection == null) {
            return null;
        }
        ArrayList<B> output = new ArrayList<B>(collection.size());
        for (A element : collection) {
            output.add(transformFunction.apply(element));
        }
        return output;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <A, B> Set<B> toHashSet(@Nullable Collection<A> collection, @NotNull Function<A, B> transformFunction) {
        if (collection == null) {
            return null;
        }
        int initialSize = Math.max((int)((float)collection.size() / 0.75f) + 1, 16);
        HashSet<B> output = new HashSet<B>(initialSize);
        for (A element : collection) {
            output.add(transformFunction.apply(element));
        }
        return output;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <A, B> ImmutableList<B> toImmutableList(@Nullable Collection<A> collection, @NotNull Function<A, B> transformFunction) {
        if (collection == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (A element : collection) {
            builder.add(transformFunction.apply(element));
        }
        return builder.build();
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <A, B> ImmutableSet<B> toImmutableSet(@Nullable Collection<A> collection, @NotNull Function<A, B> transformFunction) {
        if (collection == null) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (A element : collection) {
            builder.add(transformFunction.apply(element));
        }
        return builder.build();
    }
}

