/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.collection;

import java.util.Locale;
import me.filoghost.fcommons.Preconditions;
import org.jetbrains.annotations.NotNull;

public final class CaseInsensitiveString {
    private final String originalString;
    private final String uppercaseString;

    public CaseInsensitiveString(@NotNull String string) {
        Preconditions.notNull(string, "string");
        this.originalString = string;
        this.uppercaseString = string.toUpperCase(Locale.ROOT);
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public boolean equalsIgnoreCase(String other) {
        return other != null && other.toUpperCase(Locale.ROOT).equals(this.uppercaseString);
    }

    public String toString() {
        return this.originalString;
    }

    public int hashCode() {
        return this.uppercaseString.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return ((CaseInsensitiveString)other).uppercaseString.equals(this.uppercaseString);
    }
}

