/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons.collection;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.filoghost.fcommons.collection.CaseInsensitiveString;
import org.jetbrains.annotations.NotNull;

public interface CaseInsensitiveMap<V>
extends Map<CaseInsensitiveString, V> {
    @Override
    default public V put(@NotNull String key, V value) {
        return this.put(new CaseInsensitiveString(key), value);
    }

    default public V remove(@NotNull String key) {
        return this.remove(new CaseInsensitiveString(key));
    }

    default public V get(@NotNull String key) {
        return this.get(new CaseInsensitiveString(key));
    }

    default public V getOrDefault(@NotNull String key, V defaultValue) {
        return this.getOrDefault(new CaseInsensitiveString(key), defaultValue);
    }

    default public boolean containsKey(@NotNull String key) {
        return this.containsKey(new CaseInsensitiveString(key));
    }

    default public boolean remove(@NotNull String key, V value) {
        return this.remove(new CaseInsensitiveString(key), value);
    }

    default public void putAllString(@NotNull Map<? extends String, ? extends V> map) {
        LinkedHashMap<CaseInsensitiveString, V> caseInsensitiveStringMap = new LinkedHashMap<CaseInsensitiveString, V>();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            caseInsensitiveStringMap.put(new CaseInsensitiveString(entry.getKey()), entry.getValue());
        }
        this.putAll(caseInsensitiveStringMap);
    }

    @Override
    default public V putIfAbsent(@NotNull String key, V value) {
        return this.putIfAbsent(new CaseInsensitiveString(key), value);
    }

    default public V computeIfAbsent(@NotNull String key, Supplier<V> valueSupplier) {
        return (V)this.computeIfAbsent(new CaseInsensitiveString(key), (? super K k) -> valueSupplier.get());
    }

    default public V compute(@NotNull String key, UnaryOperator<V> remappingFunction) {
        return (V)this.compute(new CaseInsensitiveString(key), (? super K k, ? super V v) -> remappingFunction.apply(v));
    }

    default public V computeIfPresent(@NotNull String key, UnaryOperator<V> remappingFunction) {
        return (V)this.computeIfPresent(new CaseInsensitiveString(key), (? super K k, ? super V v) -> remappingFunction.apply(v));
    }

    @Override
    default public V merge(@NotNull String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge(new CaseInsensitiveString(key), value, remappingFunction);
    }

    default public boolean removeIf(@NotNull String key, @NotNull Predicate<V> filter) {
        AtomicBoolean removed = new AtomicBoolean(false);
        this.computeIfPresent(new CaseInsensitiveString(key), (? super K k, ? super V value) -> {
            if (filter.test(value)) {
                removed.set(true);
                return null;
            }
            return value;
        });
        return removed.get();
    }

    default public boolean removeAllIf(@NotNull BiPredicate<CaseInsensitiveString, V> filter) {
        return this.entrySet().removeIf(entry -> filter.test((CaseInsensitiveString)entry.getKey(), entry.getValue()));
    }
}

