/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons;

import java.util.HashSet;
import java.util.Set;
import me.filoghost.fcommons.FeatureSupport;
import me.filoghost.fcommons.collection.EnumLookupRegistry;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public final class MaterialsHelper {
    private static final EnumLookupRegistry<Material> MATERIALS_REGISTRY = MaterialsHelper.initMaterialsRegistry();
    private static final Set<Material> AIR_MATERIALS = MaterialsHelper.getExistingMaterials("AIR", "CAVE_AIR", "VOID_AIR");

    private static EnumLookupRegistry<Material> initMaterialsRegistry() {
        EnumLookupRegistry<Material> materialsRegistry = EnumLookupRegistry.fromEnumValues(Material.class);
        if (FeatureSupport.LEGACY_MATERIAL_IDS) {
            for (Material material : Material.values()) {
                materialsRegistry.put(Integer.toString(material.getId()), material);
            }
        }
        materialsRegistry.putEnumIfExisting("iron bar", "IRON_FENCE");
        materialsRegistry.putEnumIfExisting("iron bars", "IRON_FENCE");
        materialsRegistry.putEnumIfExisting("glass pane", "THIN_GLASS");
        materialsRegistry.putEnumIfExisting("nether wart", "NETHER_STALK");
        materialsRegistry.putEnumIfExisting("nether warts", "NETHER_STALK");
        materialsRegistry.putEnumIfExisting("slab", "STEP");
        materialsRegistry.putEnumIfExisting("double slab", "DOUBLE_STEP");
        materialsRegistry.putEnumIfExisting("stone brick", "SMOOTH_BRICK");
        materialsRegistry.putEnumIfExisting("stone bricks", "SMOOTH_BRICK");
        materialsRegistry.putEnumIfExisting("stone stair", "SMOOTH_STAIRS");
        materialsRegistry.putEnumIfExisting("stone stairs", "SMOOTH_STAIRS");
        materialsRegistry.putEnumIfExisting("potato", "POTATO_ITEM");
        materialsRegistry.putEnumIfExisting("carrot", "CARROT_ITEM");
        materialsRegistry.putEnumIfExisting("brewing stand", "BREWING_STAND_ITEM");
        materialsRegistry.putEnumIfExisting("cauldron", "CAULDRON_ITEM");
        materialsRegistry.putEnumIfExisting("carrot on stick", "CARROT_STICK");
        materialsRegistry.putEnumIfExisting("carrot on a stick", "CARROT_STICK");
        materialsRegistry.putEnumIfExisting("cobblestone wall", "COBBLE_WALL");
        materialsRegistry.putEnumIfExisting("acacia wood stairs", "ACACIA_STAIRS");
        materialsRegistry.putEnumIfExisting("dark oak wood stairs", "DARK_OAK_STAIRS");
        materialsRegistry.putEnumIfExisting("wood slab", "WOOD_STEP");
        materialsRegistry.putEnumIfExisting("double wood slab", "WOOD_DOUBLE_STEP");
        materialsRegistry.putEnumIfExisting("repeater", "DIODE");
        materialsRegistry.putEnumIfExisting("piston", "PISTON_BASE");
        materialsRegistry.putEnumIfExisting("sticky piston", "PISTON_STICKY_BASE");
        materialsRegistry.putEnumIfExisting("flower pot", "FLOWER_POT_ITEM");
        materialsRegistry.putEnumIfExisting("wood shovel", "WOOD_SPADE");
        materialsRegistry.putEnumIfExisting("stone shovel", "STONE_SPADE");
        materialsRegistry.putEnumIfExisting("gold shovel", "GOLD_SPADE");
        materialsRegistry.putEnumIfExisting("iron shovel", "IRON_SPADE");
        materialsRegistry.putEnumIfExisting("diamond shovel", "DIAMOND_SPADE");
        materialsRegistry.putEnumIfExisting("steak", "COOKED_BEEF");
        materialsRegistry.putEnumIfExisting("cooked porkchop", "GRILLED_PORK");
        materialsRegistry.putEnumIfExisting("raw porkchop", "PORK");
        materialsRegistry.putEnumIfExisting("hardened clay", "HARD_CLAY");
        materialsRegistry.putEnumIfExisting("huge brown mushroom", "HUGE_MUSHROOM_1");
        materialsRegistry.putEnumIfExisting("huge red mushroom", "HUGE_MUSHROOM_2");
        materialsRegistry.putEnumIfExisting("mycelium", "MYCEL");
        materialsRegistry.putEnumIfExisting("poppy", "RED_ROSE");
        materialsRegistry.putEnumIfExisting("comparator", "REDSTONE_COMPARATOR");
        materialsRegistry.putEnumIfExisting("skull", "SKULL_ITEM");
        materialsRegistry.putEnumIfExisting("head", "SKULL_ITEM");
        materialsRegistry.putEnumIfExisting("redstone torch", "REDSTONE_TORCH_ON");
        materialsRegistry.putEnumIfExisting("redstone lamp", "REDSTONE_LAMP_OFF");
        materialsRegistry.putEnumIfExisting("glistering melon", "SPECKLED_MELON");
        materialsRegistry.putEnumIfExisting("acacia leaves", "LEAVES_2");
        materialsRegistry.putEnumIfExisting("acacia log", "LOG_2");
        materialsRegistry.putEnumIfExisting("gunpowder", "SULPHUR");
        materialsRegistry.putEnumIfExisting("lilypad", "WATER_LILY");
        materialsRegistry.putEnumIfExisting("command block", "COMMAND");
        materialsRegistry.putEnumIfExisting("dye", "INK_SACK");
        return materialsRegistry;
    }

    @Nullable
    public static Material matchMaterial(String materialName) {
        return (Material)MATERIALS_REGISTRY.lookup(materialName);
    }

    private static Set<Material> getExistingMaterials(String ... materialEnumNames) {
        HashSet<Material> existingMaterials = new HashSet<Material>();
        for (String materialEnumName : materialEnumNames) {
            try {
                existingMaterials.add(Material.valueOf((String)materialEnumName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return existingMaterials;
    }

    public static boolean isAir(Material material) {
        return AIR_MATERIALS.contains(material);
    }
}

