/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.fcommons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.filoghost.fcommons.EnhancedJavaPlugin;
import me.filoghost.fcommons.ExceptionUtils;
import me.filoghost.fcommons.FCommons;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public abstract class FCommonsPlugin
extends EnhancedJavaPlugin {
    public final void onEnable() {
        try {
            FCommons.setPluginInstance((Plugin)this);
            this.checkPackageRelocation();
            this.onCheckedEnable();
        }
        catch (PluginEnableException e) {
            this.criticalShutdown(e.getMessageLines(), e.getCause());
        }
        catch (Throwable t) {
            this.criticalShutdown(null, t);
        }
    }

    protected abstract void onCheckedEnable() throws PluginEnableException;

    private void checkPackageRelocation() {
        String defaultPackage = "me-filoghost-fcommons".replace("-", ".");
        if (FCommonsPlugin.class.getPackage().getName().equals(defaultPackage)) {
            throw new IllegalStateException("FCommons must be relocated to another package");
        }
    }

    private void criticalShutdown(List<String> errorMessageLines, Throwable throwable) {
        this.printCriticalError(errorMessageLines, throwable);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> Bukkit.getConsoleSender().sendMessage(this.getFatalErrorPrefix() + "Fatal error while enabling the plugin. Check previous logs for more information."), 10L);
        this.setEnabled(false);
    }

    protected void printCriticalError(List<String> errorMessageLines, Throwable throwable) {
        ArrayList<String> output = new ArrayList<String>();
        if (errorMessageLines != null) {
            output.add(this.getFatalErrorPrefix() + "Fatal error while enabling " + this.getNameWithVersion() + ":");
        } else {
            output.add(this.getFatalErrorPrefix() + "Fatal unexpected error while enabling " + this.getNameWithVersion() + ":");
        }
        if (errorMessageLines != null) {
            output.add("");
            output.addAll(errorMessageLines);
        }
        if (throwable != null) {
            output.add("");
            output.addAll(ExceptionUtils.getStackTraceOutputLines(throwable));
            output.add("");
        }
        output.add("The plugin has been disabled.");
        output.add("");
        Bukkit.getConsoleSender().sendMessage(String.join((CharSequence)"\n", output));
    }

    private String getNameWithVersion() {
        return this.getDescription().getName() + " v" + this.getDescription().getVersion();
    }

    private String getFatalErrorPrefix() {
        return ChatColor.DARK_RED + "[" + this.getDescription().getName() + "] " + ChatColor.RED;
    }

    public static class PluginEnableException
    extends Exception {
        private final List<String> messageLines;

        public PluginEnableException(String ... message) {
            this((Throwable)null, message);
        }

        public PluginEnableException(Throwable cause, String ... message) {
            super(String.join((CharSequence)" ", message), cause);
            this.messageLines = Arrays.asList(message);
        }

        public List<String> getMessageLines() {
            return this.messageLines;
        }
    }
}

