/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.InternalHologramLoadException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.ExceptionUtils;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigSyntaxException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorLog;
import me.filoghost.holographicdisplays.plugin.log.ErrorDisplayInfo;
import me.filoghost.holographicdisplays.plugin.log.MessagePartJoiner;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class PrintableErrorCollector
extends ErrorCollector {
    private static final String ERROR_PREFIX = ChatColor.RED + "[Illusion] ";

    public void logSummaryToConsole() {
        Bukkit.getConsoleSender().sendMessage(ERROR_PREFIX + "Encountered " + this.getErrorsCount() + " error(s) on load. Check previous console logs for more information.");
    }

    @Override
    public void logToConsole() {
        ArrayList<String> outputLines = new ArrayList<String>();
        if (this.errors.size() > 0) {
            outputLines.add(ERROR_PREFIX + "Encountered " + this.errors.size() + " error(s) on load:");
            outputLines.add(" ");
            for (int i = 0; i < this.errors.size(); ++i) {
                ErrorDisplayInfo errorDisplayInfo = this.getDisplayInfo((ErrorLog)this.errors.get(i));
                PrintableErrorCollector.displayError(outputLines, i + 1, errorDisplayInfo);
            }
        }
        Bukkit.getConsoleSender().sendMessage(String.join((CharSequence)(ChatColor.RESET + "\n"), outputLines));
    }

    private ErrorDisplayInfo getDisplayInfo(ErrorLog error) {
        ArrayList<String> messageParts = new ArrayList<String>((Collection<String>)error.getMessage());
        String details = null;
        Throwable exception = error.getCause();
        while (true) {
            if (exception instanceof ConfigSyntaxException) {
                messageParts.add(exception.getMessage());
                details = ((ConfigSyntaxException)exception).getSyntaxErrorDetails();
                break;
            }
            if (!(exception instanceof ConfigException) && !(exception instanceof InternalHologramLoadException)) break;
            messageParts.add(exception.getMessage());
            exception = exception.getCause();
        }
        return new ErrorDisplayInfo(messageParts, details, exception);
    }

    private static void displayError(List<String> outputLines, int index, ErrorDisplayInfo errorDisplayInfo) {
        StringBuilder message = new MessagePartJoiner(errorDisplayInfo.getMessageParts()).getOutput();
        if (!Strings.hasSentenceEnding(message.toString())) {
            message.append(".");
        }
        if (errorDisplayInfo.getDetails() != null) {
            message.append(" Details:");
        }
        outputLines.add("" + ChatColor.YELLOW + index + ") " + ChatColor.WHITE + message);
        if (errorDisplayInfo.getDetails() != null) {
            outputLines.add(ChatColor.YELLOW + errorDisplayInfo.getDetails());
        }
        if (errorDisplayInfo.getException() != null) {
            outputLines.add(ChatColor.DARK_GRAY + "------------[ Exception details ]------------");
            for (String stackTraceLine : ExceptionUtils.getStackTraceOutputLines(errorDisplayInfo.getException())) {
                outputLines.add(ChatColor.DARK_GRAY + stackTraceLine);
            }
            outputLines.add(ChatColor.DARK_GRAY + "---------------------------------------------");
        }
        outputLines.add(" ");
    }
}

