/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.internal.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import org.jetbrains.annotations.Nullable;

public class InternalHologramManager {
    private final HolographicDisplaysAPI api;
    private final List<InternalHologram> holograms;

    public InternalHologramManager(HolographicDisplaysAPI api) {
        this.api = api;
        this.holograms = new ArrayList<InternalHologram>();
    }

    @Nullable
    public InternalHologram getHologramByName(String name) {
        for (InternalHologram hologram : this.holograms) {
            if (!hologram.getName().equalsIgnoreCase(name)) continue;
            return hologram;
        }
        return null;
    }

    public InternalHologram createHologram(String name, Position position) {
        if (this.getHologramByName(name) != null) {
            throw new IllegalStateException("hologram named \"" + name + "\" already exists");
        }
        InternalHologram hologram = new InternalHologram(this.api, name, position);
        this.holograms.add(hologram);
        return hologram;
    }

    public List<InternalHologram> getHolograms() {
        return Collections.unmodifiableList(this.holograms);
    }

    public void deleteHologram(InternalHologram hologram) {
        this.holograms.remove(hologram);
        hologram.delete();
    }

    public void deleteHolograms() {
        for (InternalHologram hologram : this.holograms) {
            hologram.delete();
        }
        this.holograms.clear();
    }
}

