/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Colors;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public class ImageMessage {
    private static final List<ColorMapping> COLORS = Arrays.asList(new ColorMapping(new Color(0, 0, 170), ChatColor.DARK_BLUE), new ColorMapping(new Color(0, 170, 0), ChatColor.DARK_GREEN), new ColorMapping(new Color(0, 170, 170), ChatColor.DARK_AQUA), new ColorMapping(new Color(170, 0, 0), ChatColor.DARK_RED), new ColorMapping(new Color(170, 0, 170), ChatColor.DARK_PURPLE), new ColorMapping(new Color(255, 170, 0), ChatColor.GOLD), new ColorMapping(new Color(85, 85, 255), ChatColor.BLUE), new ColorMapping(new Color(85, 255, 85), ChatColor.GREEN), new ColorMapping(new Color(85, 255, 255), ChatColor.AQUA), new ColorMapping(new Color(255, 85, 85), ChatColor.RED), new ColorMapping(new Color(255, 85, 255), ChatColor.LIGHT_PURPLE), new ColorMapping(new Color(255, 255, 85), ChatColor.YELLOW));
    private static final List<ColorMapping> GRAYS = Arrays.asList(new ColorMapping(new Color(0, 0, 0), ChatColor.BLACK), new ColorMapping(new Color(85, 85, 85), ChatColor.DARK_GRAY), new ColorMapping(new Color(170, 170, 170), ChatColor.GRAY), new ColorMapping(new Color(255, 255, 255), ChatColor.WHITE));
    private final List<String> lines;

    public ImageMessage(BufferedImage image, int width) {
        this.lines = this.toChatLines(this.resizeImage(image, width));
    }

    private List<String> toChatLines(BufferedImage image) {
        ArrayList<String> lines = new ArrayList<String>(image.getHeight());
        String transparencySymbol = Settings.transparencySymbol;
        String imageSymbol = Settings.imageSymbol;
        for (int y = 0; y < image.getHeight(); ++y) {
            StringBuilder line = new StringBuilder();
            for (int x = 0; x < image.getWidth(); ++x) {
                ChatColor pixelColor = this.getClosestChatColor(image, x, y);
                if (pixelColor == null) {
                    line.append(ChatColor.RESET);
                    line.append(transparencySymbol);
                    continue;
                }
                line.append(pixelColor);
                line.append(imageSymbol);
            }
            lines.add(Colors.optimize(line.toString()));
        }
        return lines;
    }

    private BufferedImage resizeImage(BufferedImage image, int width) {
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        int height = (int)((double)width * ratio);
        if (height == 0) {
            height = 1;
        }
        return this.toBufferedImage(image.getScaledInstance(width, height, 1));
    }

    private BufferedImage toBufferedImage(Image img) {
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(img, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    @Nullable
    private ChatColor getClosestChatColor(BufferedImage image, int x, int y) {
        Color color = new Color(image.getRGB(x, y), true);
        if (color.getAlpha() < 80) {
            return null;
        }
        for (ColorMapping colorMapping : COLORS) {
            if (!colorMapping.isIdenticalTo(color)) continue;
            return colorMapping.chatColor;
        }
        ColorMapping bestGrayMatch = this.getClosestColorMapping(GRAYS, color);
        if (bestGrayMatch.getDistance(color) < 17500.0) {
            return bestGrayMatch.chatColor;
        }
        return this.getClosestColorMapping(COLORS, color).chatColor;
    }

    private ColorMapping getClosestColorMapping(Collection<ColorMapping> colorMappings, Color color) {
        double bestDistance = 0.0;
        ColorMapping bestMatch = null;
        for (ColorMapping colorMapping : colorMappings) {
            double distance = colorMapping.getDistance(color);
            if (bestMatch != null && !(distance < bestDistance)) continue;
            bestMatch = colorMapping;
            bestDistance = distance;
        }
        return bestMatch;
    }

    public List<String> getLines() {
        return this.lines;
    }

    private static class ColorMapping {
        private final Color color;
        private final ChatColor chatColor;

        ColorMapping(Color color, ChatColor chatColor) {
            this.chatColor = chatColor;
            this.color = color;
        }

        boolean isIdenticalTo(Color otherColor) {
            return Math.abs(this.color.getRed() - otherColor.getRed()) <= 5 && Math.abs(this.color.getGreen() - otherColor.getGreen()) <= 5 && Math.abs(this.color.getBlue() - otherColor.getBlue()) <= 5;
        }

        double getDistance(Color otherColor) {
            int redDiff = this.color.getRed() - otherColor.getRed();
            int greenDiff = this.color.getGreen() - otherColor.getGreen();
            int blueDiff = this.color.getBlue() - otherColor.getBlue();
            double redMean = (double)(this.color.getRed() + otherColor.getRed()) / 2.0;
            double redWeight = 2.0 + redMean / 256.0;
            double greenWeight = 4.0;
            double blueWeight = 2.0 + (255.0 - redMean) / 256.0;
            return redWeight * (double)redDiff * (double)redDiff + greenWeight * (double)greenDiff * (double)greenDiff + blueWeight * (double)blueDiff * (double)blueDiff;
        }
    }
}

