/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config.upgrade;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.upgrade.LegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.Config;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigSaveException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.util.FileUtils;

public class AnimationsLegacyUpgrade
extends LegacyUpgrade {
    private static final String SPEED_PREFIX = "speed:";
    private final Path animationFolder;

    public AnimationsLegacyUpgrade(ConfigManager configManager, ErrorCollector errorCollector) {
        super(configManager, errorCollector);
        this.animationFolder = configManager.getAnimationsFolder();
    }

    @Override
    public Path getFile() {
        return this.animationFolder;
    }

    @Override
    public void run() throws IOException {
        if (!Files.isDirectory(this.animationFolder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> animationFiles = Files.list(this.animationFolder);){
            animationFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.tryRun((Path)file, () -> this.upgradeAnimationFile((Path)file)));
        }
    }

    private void upgradeAnimationFile(Path oldFile) throws IOException, ConfigSaveException {
        double speed;
        String oldFileName = oldFile.getFileName().toString();
        if (FileUtils.hasFileExtension(oldFileName, "yml")) {
            return;
        }
        List<String> lines = Files.readAllLines(oldFile);
        if (lines.size() == 0) {
            return;
        }
        String firstLine = lines.remove(0).trim();
        if (!firstLine.toLowerCase(Locale.ROOT).startsWith(SPEED_PREFIX)) {
            return;
        }
        String newFileName = FileUtils.hasFileExtension(oldFileName, "txt") ? FileUtils.removeFileExtension(oldFileName) + ".yml" : oldFileName + ".yml";
        Path newFile = oldFile.resolveSibling(newFileName);
        if (Files.isRegularFile(newFile, new LinkOption[0])) {
            return;
        }
        try {
            speed = Double.parseDouble(firstLine.substring(SPEED_PREFIX.length()).trim());
        }
        catch (NumberFormatException e) {
            speed = 0.5;
        }
        Config config = new Config();
        config.setDouble("interval-seconds", speed);
        config.setStringList("animation-frames", lines);
        this.createBackupFile(oldFile);
        this.configManager.getConfigLoader(newFile).save(config);
        Files.delete(oldFile);
    }
}

