/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommand;
import org.jetbrains.annotations.NotNull;

public abstract class HologramSubCommand
implements SubCommand {
    private final String name;
    private final List<String> aliases;
    private final String permission;
    private String usageArgs;
    private int minArgs;
    private List<String> description;
    private boolean showInHelpCommand;

    protected HologramSubCommand(String name, String ... aliases) {
        this.name = name;
        this.aliases = aliases != null ? Arrays.asList(aliases) : Collections.emptyList();
        this.permission = "holographicdisplays.command." + name.toLowerCase(Locale.ROOT);
        this.showInHelpCommand = true;
    }

    public final String getFullUsageText(CommandContext context) {
        return "/" + context.getRootLabel() + " " + this.name + (this.usageArgs != null ? " " + this.usageArgs : "");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getPermission() {
        return this.permission;
    }

    @Override
    public final String getPermissionMessage() {
        return null;
    }

    @Override
    public final String getUsageArgs() {
        return this.usageArgs;
    }

    public final void setUsageArgs(String usageArgs) {
        this.usageArgs = usageArgs;
    }

    @Override
    public final int getMinArgs() {
        return this.minArgs;
    }

    public final void setMinArgs(int minArgs) {
        this.minArgs = minArgs;
    }

    @NotNull
    public final List<String> getAliases() {
        return this.aliases;
    }

    public final void setDescription(String ... description) {
        this.description = Arrays.asList(description);
    }

    public List<String> getDescription(CommandContext context) {
        return this.description;
    }

    public final void setShowInHelpCommand(boolean show) {
        this.showInHelpCommand = show;
    }

    public final boolean isShowInHelpCommand() {
        return this.showInHelpCommand;
    }
}

