/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_21_R1;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import me.filoghost.holographicdisplays.nms.v1_21_R1.DataWatcherKey;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.MinecraftServer;

class PacketByteBuffer {
    private static final ThreadLocal<PacketByteBuffer> LOCAL_INSTANCE = ThreadLocal.withInitial(PacketByteBuffer::new);
    private final RegistryFriendlyByteBuf serializer;

    static PacketByteBuffer get() {
        PacketByteBuffer instance = LOCAL_INSTANCE.get();
        instance.clear();
        return instance;
    }

    private PacketByteBuffer() {
        ByteBuf byteBuf = Unpooled.buffer();
        MinecraftServer.getServer();
        this.serializer = new RegistryFriendlyByteBuf(byteBuf, MinecraftServer.getDefaultRegistryAccess());
    }

    void writeBoolean(boolean flag) {
        this.serializer.writeBoolean(flag);
    }

    void writeByte(int i) {
        this.serializer.writeByte(i);
    }

    void writeShort(int i) {
        this.serializer.writeShort(i);
    }

    void writeInt(int i) {
        this.serializer.writeInt(i);
    }

    void writeDouble(double d) {
        this.serializer.writeDouble(d);
    }

    void writeVarInt(int i) {
        this.serializer.c(i);
    }

    void writeVarIntArray(int i1) {
        this.writeVarInt(1);
        this.writeVarInt(i1);
    }

    void writeVarIntArray(int i1, int i2) {
        this.writeVarInt(2);
        this.writeVarInt(i1);
        this.writeVarInt(i2);
    }

    void writeUUID(UUID uuid) {
        this.serializer.a(uuid);
    }

    <T> void writeDataWatcherEntry(DataWatcherKey<T> key, T value) {
        this.serializer.writeByte(key.getIndex());
        this.writeVarInt(key.getSerializerTypeID());
        key.getSerializer().codec().encode((Object)this.serializer, value);
    }

    void writeDataWatcherEntriesEnd() {
        this.serializer.writeByte(255);
    }

    public RegistryFriendlyByteBuf getInternalSerializer() {
        return this.serializer;
    }

    void clear() {
        this.serializer.clear();
    }
}

