/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_20_R4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.FallbackEntityIDGenerator;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.PacketListener;
import me.filoghost.holographicdisplays.nms.common.entity.ClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.ItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.TextNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_20_R4.DataWatcherKey;
import me.filoghost.holographicdisplays.nms.v1_20_R4.InboundPacketHandler;
import me.filoghost.holographicdisplays.nms.v1_20_R4.VersionClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_20_R4.VersionItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_20_R4.VersionTextNMSPacketEntity;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VersionNMSManager
implements NMSManager {
    private static final ReflectField<AtomicInteger> ENTITY_ID_COUNTER_FIELD = ReflectField.lookup(AtomicInteger.class, Entity.class, "c");
    private static final ReflectField<NetworkManager> NETWORK_MANAGER_FIELD = ReflectField.lookup(NetworkManager.class, ServerCommonPacketListenerImpl.class, "e");
    private final Supplier<Integer> entityIDGenerator;

    public VersionNMSManager(ErrorCollector errorCollector) {
        this.entityIDGenerator = this.getEntityIDGenerator(errorCollector);
        DataWatcherKey.ENTITY_STATUS.getIndex();
    }

    private Supplier<Integer> getEntityIDGenerator(ErrorCollector errorCollector) {
        try {
            AtomicInteger nmsEntityIDCounter = ENTITY_ID_COUNTER_FIELD.getStatic();
            return nmsEntityIDCounter::incrementAndGet;
        }
        catch (ReflectiveOperationException e) {
            errorCollector.add(e, "Could not get the NMS entity ID generator. There is a small chance of entity ID conflicts, causing client-side issues on single entities.");
            return new FallbackEntityIDGenerator();
        }
    }

    private EntityID newEntityID() {
        return new EntityID(this.entityIDGenerator);
    }

    @Override
    public TextNMSPacketEntity newTextPacketEntity() {
        return new VersionTextNMSPacketEntity(this.newEntityID());
    }

    @Override
    public ItemNMSPacketEntity newItemPacketEntity() {
        return new VersionItemNMSPacketEntity(this.newEntityID(), this.newEntityID());
    }

    @Override
    public ClickableNMSPacketEntity newClickablePacketEntity() {
        return new VersionClickableNMSPacketEntity(this.newEntityID());
    }

    @Override
    public void injectPacketListener(Player player, PacketListener packetListener) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
            pipeline.addBefore("packet_handler", "holographic_displays_listener", (ChannelHandler)new InboundPacketHandler(player, packetListener));
        });
    }

    @Override
    public void uninjectPacketListener(Player player) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
        });
    }

    private void modifyPipeline(Player player, Consumer<ChannelPipeline> pipelineModifierTask) {
        NetworkManager networkManager;
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().c;
        try {
            networkManager = NETWORK_MANAGER_FIELD.get(playerConnection);
        }
        catch (ReflectiveOperationException e) {
            Log.warning("Unexpected error while modifying the channel pipeline.", e);
            return;
        }
        Channel channel = networkManager.n;
        if (channel == null) {
            return;
        }
        EventLoop eventLoop = channel.eventLoop();
        Runnable safeModifierTask = () -> {
            if (!player.isOnline()) {
                return;
            }
            try {
                pipelineModifierTask.accept(channel.pipeline());
            }
            catch (Exception e) {
                Log.warning("Unexpected error while modifying the channel pipeline.", e);
            }
        };
        if (eventLoop.inEventLoop()) {
            safeModifierTask.run();
        } else {
            eventLoop.execute(safeModifierTask);
        }
    }
}

