/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_15_R1;

import java.util.Optional;
import me.filoghost.holographicdisplays.nms.v1_15_R1.DataWatcherKey;
import me.filoghost.holographicdisplays.nms.v1_15_R1.PacketByteBuffer;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.inventory.ItemStack;

abstract class DataWatcherPacketBuilder<T> {
    private static final int MAX_CUSTOM_NAME_LENGTH = 5000;
    private final PacketByteBuffer packetByteBuffer;

    DataWatcherPacketBuilder(PacketByteBuffer packetByteBuffer) {
        this.packetByteBuffer = packetByteBuffer;
    }

    DataWatcherPacketBuilder<T> setInvisible() {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ENTITY_STATUS, (byte)32);
        return this;
    }

    DataWatcherPacketBuilder<T> setArmorStandMarker() {
        this.setInvisible();
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ARMOR_STAND_STATUS, (byte)27);
        return this;
    }

    DataWatcherPacketBuilder<T> setCustomName(String customName) {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.CUSTOM_NAME, this.getCustomNameDataWatcherValue(customName));
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.CUSTOM_NAME_VISIBILITY, !Strings.isEmpty(customName));
        return this;
    }

    private Optional<IChatBaseComponent> getCustomNameDataWatcherValue(String customName) {
        if (!Strings.isEmpty(customName = Strings.truncate(customName, 5000))) {
            return Optional.of(CraftChatMessage.fromString((String)customName, (boolean)false)[0]);
        }
        return Optional.empty();
    }

    DataWatcherPacketBuilder<T> setItemStack(ItemStack itemStack) {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ITEM_STACK, CraftItemStack.asNMSCopy((ItemStack)itemStack));
        return this;
    }

    DataWatcherPacketBuilder<T> setSlimeSmall() {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.SLIME_SIZE, 1);
        return this;
    }

    T build() {
        this.packetByteBuffer.writeDataWatcherEntriesEnd();
        return this.createPacket(this.packetByteBuffer);
    }

    abstract T createPacket(PacketByteBuffer var1);
}

