/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.core.base.BaseHologramLine;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tracking.ImmutableViewers;
import me.filoghost.holographicdisplays.core.tracking.MutableViewers;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import me.filoghost.holographicdisplays.core.tracking.Viewers;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class LineTracker<T extends Viewer> {
    private final ConcurrentMap<Player, T> viewers = new ConcurrentHashMap<Player, T>();
    private String positionWorldName;
    protected PositionCoordinates positionCoordinates;
    private boolean positionChanged;
    private boolean inLoadedChunk;
    private int lastVisibilitySettingsVersion;

    protected LineTracker() {
    }

    protected abstract BaseHologramLine getLine();

    final boolean shouldBeRemoved() {
        return this.getLine().isDeleted();
    }

    @MustBeInvokedByOverriders
    public void onRemoval() {
        this.resetViewersAndSendDestroyPackets();
    }

    @MustBeInvokedByOverriders
    protected void update(List<CachedPlayer> onlinePlayers, List<CachedPlayer> movedPlayers, int maxViewRange) {
        boolean textChanged;
        boolean sendChangesPackets = false;
        if (this.getLine().hasChanged()) {
            this.getLine().clearChanged();
            this.detectChanges();
            sendChangesPackets = true;
        }
        if (this.hasViewers() && (textChanged = this.updatePlaceholders())) {
            sendChangesPackets = true;
        }
        if (sendChangesPackets && this.hasViewers()) {
            this.sendChangesPackets(new ImmutableViewers(this.viewers.values()));
        }
        this.modifyViewersAndSendPackets(onlinePlayers, movedPlayers, maxViewRange);
        if (sendChangesPackets) {
            this.clearDetectedChanges();
        }
    }

    protected abstract boolean updatePlaceholders();

    private void modifyViewersAndSendPackets(List<CachedPlayer> onlinePlayers, List<CachedPlayer> movedPlayers, int maxViewRange) {
        int visibilitySettingsVersion;
        if (!this.getLine().isInLoadedChunk()) {
            if (this.inLoadedChunk) {
                this.inLoadedChunk = false;
                this.resetViewersAndSendDestroyPackets();
            }
            return;
        }
        boolean checkAllPlayers = false;
        if (!this.inLoadedChunk) {
            this.inLoadedChunk = true;
            checkAllPlayers = true;
        }
        if ((visibilitySettingsVersion = this.getLine().getVisibilitySettings().getVersion()) != this.lastVisibilitySettingsVersion) {
            this.lastVisibilitySettingsVersion = visibilitySettingsVersion;
            checkAllPlayers = true;
        }
        if (this.positionChanged) {
            checkAllPlayers = true;
        }
        List<CachedPlayer> playersToCheck = checkAllPlayers ? onlinePlayers : movedPlayers;
        MutableViewers<T> addedPlayers = null;
        MutableViewers<T> removedPlayers = null;
        int size = playersToCheck.size();
        for (int i = 0; i < size; ++i) {
            Object viewer;
            CachedPlayer player = playersToCheck.get(i);
            Player bukkitPlayer = player.getBukkitPlayer();
            if (this.shouldTrackPlayer(player, maxViewRange)) {
                if (this.viewers.containsKey(bukkitPlayer)) continue;
                viewer = this.createViewer(player);
                this.viewers.put(bukkitPlayer, viewer);
                if (addedPlayers == null) {
                    addedPlayers = new MutableViewers<T>();
                }
                addedPlayers.add(viewer);
                continue;
            }
            if (!this.viewers.containsKey(bukkitPlayer)) continue;
            viewer = (Viewer)this.viewers.remove(bukkitPlayer);
            if (removedPlayers == null) {
                removedPlayers = new MutableViewers<T>();
            }
            removedPlayers.add(viewer);
        }
        if (addedPlayers != null) {
            this.sendSpawnPackets(addedPlayers);
        }
        if (removedPlayers != null) {
            this.sendDestroyPackets(removedPlayers);
        }
    }

    private boolean shouldTrackPlayer(CachedPlayer player, int maxViewRange) {
        Location playerLocation = player.getLocation();
        if (playerLocation == null || playerLocation.getWorld() != this.getLine().getWorldIfLoaded()) {
            return false;
        }
        double viewRange = this.getViewRange();
        if (viewRange > (double)maxViewRange) {
            viewRange = maxViewRange;
        }
        double diffX = Math.abs(playerLocation.getX() - this.positionCoordinates.getX());
        double diffZ = Math.abs(playerLocation.getZ() - this.positionCoordinates.getZ());
        return diffX <= viewRange && diffZ <= viewRange && this.getLine().isVisibleTo(player.getBukkitPlayer());
    }

    protected abstract double getViewRange();

    protected abstract T createViewer(CachedPlayer var1);

    protected final boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected final Collection<T> getViewers() {
        return this.viewers.values();
    }

    protected final boolean isViewer(Player player) {
        return this.viewers.containsKey(player);
    }

    protected final void removeViewer(Player player) {
        this.viewers.remove(player);
    }

    protected boolean canInteract(Player player) {
        return !this.getLine().isDeleted() && player.isOnline() && player.getGameMode() != GameMode.SPECTATOR && this.isViewer(player) && this.getLine().isVisibleTo(player);
    }

    @MustBeInvokedByOverriders
    protected void detectChanges() {
        String positionWorldName;
        PositionCoordinates positionCoordinates = this.getLine().getCoordinates();
        if (!Objects.equals(this.positionCoordinates, positionCoordinates)) {
            this.positionCoordinates = positionCoordinates;
            this.positionChanged = true;
        }
        if (!Objects.equals(this.positionWorldName, positionWorldName = this.getLine().getWorldName())) {
            this.positionWorldName = positionWorldName;
            this.positionChanged = true;
        }
    }

    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        this.positionChanged = false;
    }

    protected final void resetViewersAndSendDestroyPackets() {
        if (!this.hasViewers()) {
            return;
        }
        this.sendDestroyPackets(new ImmutableViewers(this.viewers.values()));
        this.viewers.clear();
    }

    protected abstract void sendSpawnPackets(Viewers<T> var1);

    protected abstract void sendDestroyPackets(Viewers<T> var1);

    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<T> viewers) {
        if (this.positionChanged) {
            this.sendPositionChangePackets(viewers);
        }
    }

    protected abstract void sendPositionChangePackets(Viewers<T> var1);
}

