/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.parsing;

import java.util.ArrayList;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.core.placeholder.parsing.PlaceholderPart;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringPart;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringWithPlaceholders;
import org.jetbrains.annotations.NotNull;

class Parser {
    private static final char PLACEHOLDER_START_CHAR = '{';
    private static final char PLACEHOLDER_END_CHAR = '}';
    private static final char ESCAPE_CHAR = '\\';

    Parser() {
    }

    @NotNull
    static StringWithPlaceholders parse(@NotNull String string, boolean keepEscapes) {
        ArrayList<StringPart> parts = null;
        int placeholderStartIndex = -1;
        int lastAppendIndex = 0;
        for (int currentIndex = 0; currentIndex < string.length(); ++currentIndex) {
            char nextChar;
            char currentChar = string.charAt(currentIndex);
            if (currentChar == '\\' && currentIndex < string.length() - 1 && Parser.isSpecialCharacter(nextChar = string.charAt(currentIndex + 1))) {
                ++currentIndex;
                continue;
            }
            if (placeholderStartIndex >= 0) {
                if (currentChar == '}') {
                    int endIndex = currentIndex + 1;
                    String unparsedString = Parser.substring(string, placeholderStartIndex, endIndex, keepEscapes);
                    String contentString = unparsedString.substring(1, unparsedString.length() - 1);
                    PlaceholderOccurrence content = PlaceholderOccurrence.parse(contentString);
                    if (parts == null) {
                        parts = new ArrayList<StringPart>();
                    }
                    if (placeholderStartIndex != lastAppendIndex) {
                        parts.add(new StringPart(Parser.substring(string, lastAppendIndex, placeholderStartIndex, keepEscapes)));
                    }
                    parts.add((StringPart)((Object)new PlaceholderPart(content, unparsedString)));
                    lastAppendIndex = endIndex;
                    placeholderStartIndex = -1;
                    continue;
                }
                if (currentChar != '{') continue;
                placeholderStartIndex = currentIndex;
                continue;
            }
            if (currentChar != '{') continue;
            placeholderStartIndex = currentIndex;
        }
        if (lastAppendIndex != string.length() && parts != null) {
            parts.add(new StringPart(Parser.substring(string, lastAppendIndex, string.length(), keepEscapes)));
        }
        return new StringWithPlaceholders(keepEscapes ? string : Parser.removeEscapes(string), parts);
    }

    private static String substring(String string, int startIndex, int endIndex, boolean keepEscapes) {
        String substring = string.substring(startIndex, endIndex);
        if (keepEscapes) {
            return substring;
        }
        return Parser.removeEscapes(substring);
    }

    private static String removeEscapes(String string) {
        StringBuilder output = null;
        for (int currentIndex = 0; currentIndex < string.length(); ++currentIndex) {
            char nextChar;
            char currentChar = string.charAt(currentIndex);
            if (currentChar == '\\' && currentIndex < string.length() - 1 && Parser.isSpecialCharacter(nextChar = string.charAt(currentIndex + 1))) {
                if (output == null) {
                    output = new StringBuilder(string.length());
                    output.append(string, 0, currentIndex);
                }
                output.append(nextChar);
                ++currentIndex;
                continue;
            }
            if (output == null) continue;
            output.append(currentChar);
        }
        if (output != null) {
            return output.toString();
        }
        return string;
    }

    public static String addEscapes(String string) {
        StringBuilder output = new StringBuilder(string.length() + 16);
        for (int i = 0; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (Parser.isSpecialCharacter(currentChar)) {
                output.append('\\');
            }
            output.append(currentChar);
        }
        return output.toString();
    }

    private static boolean isSpecialCharacter(char currentChar) {
        return currentChar == '\\' || currentChar == '{' || currentChar == '}';
    }
}

