/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.v2;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.internal.HologramsAPIProvider;
import com.gmail.filoghost.holographicdisplays.api.placeholder.PlaceholderReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import me.filoghost.holographicdisplays.core.api.v2.V2Hologram;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramManager;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.placeholder.registry.LegacyGlobalPlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.collection.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class V2HologramsAPIProvider
extends HologramsAPIProvider {
    private final V2HologramManager hologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    public V2HologramsAPIProvider(V2HologramManager hologramManager, PlaceholderRegistry placeholderRegistry) {
        this.hologramManager = hologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    @Override
    public Hologram createHologram(Plugin plugin, Location source) {
        Preconditions.notNull(plugin, "plugin");
        Preconditions.notNull(source, "source");
        Preconditions.notNull(source.getWorld(), "source.getWorld()");
        return this.hologramManager.createHologram(ImmutablePosition.of(source), plugin);
    }

    @Override
    public Collection<Hologram> getHolograms(Plugin plugin) {
        Preconditions.notNull(plugin, "plugin");
        ArrayList<V2Hologram> ownedHolograms = new ArrayList<V2Hologram>();
        for (V2Hologram hologram : this.hologramManager.getHolograms()) {
            if (!hologram.getCreatorPlugin().equals((Object)plugin)) continue;
            ownedHolograms.add(hologram);
        }
        return Collections.unmodifiableList(ownedHolograms);
    }

    @Override
    public boolean registerPlaceholder(Plugin plugin, String textPlaceholder, double refreshRate, PlaceholderReplacer replacer) {
        Preconditions.notNull(plugin, "plugin");
        Preconditions.notNull(textPlaceholder, "textPlaceholder");
        Preconditions.checkArgument(refreshRate >= 0.0, "refreshRate should be positive");
        Preconditions.notNull(replacer, "replacer");
        int refreshIntervalTicks = Math.min((int)(refreshRate * 20.0), 1);
        boolean alreadyRegistered = this.placeholderRegistry.isRegisteredLegacyPlaceholder(plugin, textPlaceholder);
        if (!alreadyRegistered) {
            this.placeholderRegistry.registerLegacyPlaceholder(plugin, textPlaceholder, refreshIntervalTicks, argument -> replacer.update());
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getRegisteredPlaceholders(Plugin plugin) {
        Preconditions.notNull(plugin, "plugin");
        return CollectionUtils.toArrayList(this.placeholderRegistry.getRegisteredLegacyPlaceholders(plugin), LegacyGlobalPlaceholderExpansion::getTextPlaceholder);
    }

    @Override
    public boolean unregisterPlaceholder(Plugin plugin, String textPlaceholder) {
        Preconditions.notNull(plugin, "plugin");
        Preconditions.notNull(textPlaceholder, "textPlaceholder");
        boolean registered = this.placeholderRegistry.isRegisteredLegacyPlaceholder(plugin, textPlaceholder);
        if (registered) {
            this.placeholderRegistry.unregisterLegacyPlaceholder(plugin, textPlaceholder);
            return true;
        }
        return false;
    }

    @Override
    public void unregisterPlaceholders(Plugin plugin) {
        Preconditions.notNull(plugin, "plugin");
        this.placeholderRegistry.unregisterAllLegacyPlaceholders(plugin);
    }

    @Override
    public boolean isHologramEntity(Entity bukkitEntity) {
        Preconditions.notNull(bukkitEntity, "bukkitEntity");
        return false;
    }
}

