/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core;

import com.gmail.filoghost.holographicdisplays.api.internal.HologramsAPIProvider;
import me.filoghost.holographicdisplays.api.internal.HolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.core.CoreGlobalConfig;
import me.filoghost.holographicdisplays.core.NMSVersion;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.api.current.DefaultHolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramManager;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramsAPIProvider;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.listener.ChunkListener;
import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.listener.PlayerListener;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.core.placeholder.tracking.ActivePlaceholderTracker;
import me.filoghost.holographicdisplays.core.tick.TickClock;
import me.filoghost.holographicdisplays.core.tick.TickingTask;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.core.tracking.PacketSenderExecutor;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.FCommonsPlugin;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysCore {
    private NMSManager nmsManager;
    private LineTrackerManager lineTrackerManager;
    private APIHologramManager apiHologramManager;
    private V2HologramManager v2HologramManager;

    public void enable(Plugin plugin, ErrorCollector errorCollector) throws FCommonsPlugin.PluginEnableException {
        try {
            this.nmsManager = NMSVersion.getCurrent().createNMSManager(errorCollector);
        }
        catch (NMSVersion.UnknownVersionException e) {
            throw new FCommonsPlugin.PluginEnableException(new String[]{"Holographic Displays only supports Spigot from 1.8 to 1.21.4"});
        }
        catch (NMSVersion.OutdatedVersionException e) {
            throw new FCommonsPlugin.PluginEnableException(new String[]{"Holographic Displays only supports " + e.getMinimumSupportedVersion() + " and above"});
        }
        catch (Throwable t) {
            throw new FCommonsPlugin.PluginEnableException(t, "Couldn't initialize the NMS manager.");
        }
        PacketSenderExecutor.start();
        PlaceholderRegistry placeholderRegistry = new PlaceholderRegistry();
        TickClock tickClock = new TickClock();
        ActivePlaceholderTracker placeholderTracker = new ActivePlaceholderTracker(placeholderRegistry, tickClock);
        LineClickListener lineClickListener = new LineClickListener();
        this.lineTrackerManager = new LineTrackerManager(this.nmsManager, placeholderTracker, lineClickListener);
        this.apiHologramManager = new APIHologramManager(this.lineTrackerManager);
        this.v2HologramManager = new V2HologramManager(this.lineTrackerManager);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.nmsManager.injectPacketListener(player, lineClickListener);
        }
        TickingTask tickingTask = new TickingTask(tickClock, placeholderTracker, this.lineTrackerManager, lineClickListener);
        Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, (Runnable)tickingTask, 0L, 1L);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(this.nmsManager, lineClickListener, tickingTask), plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new ChunkListener(plugin, this.apiHologramManager, this.v2HologramManager), plugin);
        HolographicDisplaysAPIProvider.setImplementation(new DefaultHolographicDisplaysAPIProvider(this.apiHologramManager, placeholderRegistry));
        this.enableLegacyAPI(this.v2HologramManager, placeholderRegistry);
    }

    private void enableLegacyAPI(V2HologramManager hologramManager, PlaceholderRegistry placeholderRegistry) {
        HologramsAPIProvider.setImplementation(new V2HologramsAPIProvider(hologramManager, placeholderRegistry));
    }

    public void setSpaceBetweenHologramLines(double spaceBetweenLines) {
        CoreGlobalConfig.spaceBetweenLines = spaceBetweenLines;
        for (BaseHologram hologram : this.apiHologramManager.getHolograms()) {
            hologram.getLines().updatePositions();
        }
        for (BaseHologram hologram : this.v2HologramManager.getHolograms()) {
            hologram.getLines().updatePositions();
        }
    }

    public void setMaxViewRange(int maxViewRange) {
        CoreGlobalConfig.maxViewRange = maxViewRange;
    }

    public void disable() {
        if (this.lineTrackerManager != null) {
            this.lineTrackerManager.resetViewersAndSendDestroyPackets();
        }
        if (this.nmsManager != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.nmsManager.uninjectPacketListener(player);
            }
        }
        PacketSenderExecutor.stopGracefully();
    }
}

