/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config.types;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListConfigType<E>
extends ConfigType<List<E>> {
    private final ConfigType<E> elementType;

    public ListConfigType(String name, ConfigType<E> elementType) {
        super(name, "value is not a list");
        this.elementType = elementType;
    }

    @Override
    protected boolean isConvertibleRawValue(@Nullable Object rawValue) {
        return rawValue instanceof List;
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull E> fromRawValue(@NotNull Object rawValue) {
        ArrayList<@NotNull E> configValue = new ArrayList<E>();
        for (Object rawElement : (List)rawValue) {
            E configElement = ListConfigType.fromRawValueOrNull(this.elementType, rawElement);
            if (configElement == null) continue;
            configValue.add(configElement);
        }
        return configValue;
    }

    @Override
    @NotNull
    protected Object toRawValue(@NotNull List<@Nullable E> configValue) {
        ArrayList<Object> rawValue = new ArrayList<Object>();
        for (E configElement : configValue) {
            if (configElement != null) {
                rawValue.add(ListConfigType.toRawValue(this.elementType, configElement));
                continue;
            }
            rawValue.add(null);
        }
        return rawValue;
    }
}

