/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.converter;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigMappingException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValidateException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValueException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.ConverterRegistry;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.converter.Converter;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.converter.ConverterHelper;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.TypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListConverter<E>
extends Converter<List<E>, List<ConfigValue>> {
    private final Converter<E, ?> elementConverter;

    public ListConverter(TypeInfo<List<E>> fieldTypeInfo) throws ConfigMappingException {
        super(ConfigType.LIST);
        TypeInfo<?> elementTypeInfo = ConverterHelper.getSingleGenericType(fieldTypeInfo);
        this.elementConverter = ConverterRegistry.fromObjectType(elementTypeInfo);
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull ConfigValue> toConfigValue0(@NotNull List<@Nullable E> fieldValue) throws ConfigMappingException {
        ArrayList<@NotNull ConfigValue> configList = new ArrayList<ConfigValue>();
        for (E fieldElement : fieldValue) {
            if (fieldElement != null) {
                configList.add(this.elementConverter.toConfigValue(fieldElement));
                continue;
            }
            configList.add(ConfigValue.NULL);
        }
        return configList;
    }

    @Override
    protected @NotNull List<@Nullable E> toFieldValue0(@NotNull @NotNull List<@NotNull ConfigValue> configList, boolean required) throws ConfigMappingException, ConfigValidateException, ConfigValueException {
        ArrayList<@Nullable E> fieldList = new ArrayList<E>();
        for (ConfigValue configElement : configList) {
            if (!this.elementConverter.isValidConfigValue(configElement)) continue;
            E fieldValue = this.elementConverter.toFieldValue(configElement, false);
            fieldList.add(fieldValue);
        }
        return fieldList;
    }

    @Override
    protected boolean equalsConfig0(@NotNull List<@Nullable E> fieldList, @NotNull @NotNull List<@NotNull ConfigValue> configList) throws ConfigMappingException {
        ArrayList<ConfigValue> filteredConfigList = new ArrayList<ConfigValue>();
        for (ConfigValue configValue : configList) {
            if (!this.elementConverter.isValidConfigValue(configValue)) continue;
            filteredConfigList.add(configValue);
        }
        if (filteredConfigList.size() != fieldList.size()) {
            return false;
        }
        for (int i = 0; i < filteredConfigList.size(); ++i) {
            ConfigValue configElement = (ConfigValue)filteredConfigList.get(i);
            E fieldElement = fieldList.get(i);
            if (this.elementConverter.equalsConfig(fieldElement, configElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean supports(Class<?> typeClass) {
        return typeClass == List.class;
    }
}

