/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigErrors;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigMappingException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValidateException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValueException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.MappedConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.MappedField;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.TypeInfo;
import org.jetbrains.annotations.NotNull;

public class ConfigMapper<T extends MappedConfigSection> {
    private final TypeInfo<T> mappedTypeInfo;
    private final List<MappedField<?>> mappedFields;

    public ConfigMapper(TypeInfo<T> typeInfo) throws ConfigMappingException {
        try {
            this.mappedTypeInfo = typeInfo;
            ImmutableList.Builder mappedFieldsBuilder = ImmutableList.builder();
            for (ReflectField<?> field : typeInfo.getDeclaredFields()) {
                if (!this.isMappable(field)) continue;
                mappedFieldsBuilder.add(new MappedField(field));
            }
            this.mappedFields = mappedFieldsBuilder.build();
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.mapperReflectionException(typeInfo), e);
        }
    }

    public T newMappedObjectInstance() throws ConfigMappingException {
        try {
            return (T)((MappedConfigSection)this.mappedTypeInfo.newInstance());
        }
        catch (NoSuchMethodException e) {
            throw new ConfigMappingException(ConfigErrors.noEmptyConstructor(this.mappedTypeInfo));
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.cannotCreateInstance(this.mappedTypeInfo), e);
        }
    }

    public Map<ConfigPath, ConfigValue> getFieldsAsConfigValues(@NotNull T mappedObject) throws ConfigMappingException {
        LinkedHashMap<ConfigPath, ConfigValue> configValues = new LinkedHashMap<ConfigPath, ConfigValue>();
        for (MappedField<?> mappedField : this.mappedFields) {
            ConfigValue configValue = mappedField.readConfigValueFromObject(mappedObject);
            configValues.put(mappedField.getConfigPath(), configValue);
        }
        return configValues;
    }

    public void setConfigFromFields(@NotNull T mappedObject, @NotNull ConfigSection config) throws ConfigMappingException {
        for (MappedField<?> mappedField : this.mappedFields) {
            ConfigValue configValue = mappedField.readConfigValueFromObject(mappedObject);
            config.set(mappedField.getConfigPath(), configValue);
        }
    }

    public void setFieldsFromConfig(@NotNull T mappedObject, @NotNull ConfigSection config) throws ConfigMappingException, ConfigValidateException, ConfigValueException {
        for (MappedField<?> mappedField : this.mappedFields) {
            mappedField.setFieldValueFromConfig(mappedObject, config);
        }
        mappedObject.afterLoad();
    }

    private boolean isMappable(ReflectField<?> field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !Modifier.isFinal(modifiers);
    }

    public boolean equalsConfig(@NotNull T mappedObject, @NotNull ConfigSection config) throws ConfigMappingException {
        for (MappedField<?> mappedField : this.mappedFields) {
            if (mappedField.equalsConfigValue(mappedObject, config)) continue;
            return false;
        }
        return true;
    }
}

