/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.internal.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.PlaceholderSetting;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class InternalHologram {
    private final Hologram renderedHologram;
    private final String name;
    private Position position;
    private final List<InternalHologramLine> lines;
    private final List<InternalHologramLine> unmodifiableLinesView;
    private boolean deleted;

    public InternalHologram(HolographicDisplaysAPI api, String name, Position position) {
        this.renderedHologram = api.createHologram(position);
        this.renderedHologram.setPlaceholderSetting(PlaceholderSetting.ENABLE_ALL);
        this.name = name;
        this.position = position;
        this.lines = new ArrayList<InternalHologramLine>();
        this.unmodifiableLinesView = Collections.unmodifiableList(this.lines);
    }

    public Hologram getRenderedHologram() {
        return this.renderedHologram;
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.checkNotDeleted();
        this.position = position;
        this.updateRendering();
    }

    public List<InternalHologramLine> getLines() {
        return this.unmodifiableLinesView;
    }

    public void addLine(InternalHologramLine line) {
        this.checkNotDeleted();
        this.lines.add(line);
        this.updateRendering();
    }

    public void addLines(List<InternalHologramLine> lines) {
        this.checkNotDeleted();
        this.lines.addAll(lines);
        this.updateRendering();
    }

    public void setLine(int index, InternalHologramLine line) {
        this.checkNotDeleted();
        this.lines.set(index, line);
        this.updateRendering();
    }

    public void setLines(List<InternalHologramLine> lines) {
        this.checkNotDeleted();
        this.lines.clear();
        this.lines.addAll(lines);
        this.updateRendering();
    }

    public void insertLine(int beforeIndex, InternalHologramLine line) {
        this.checkNotDeleted();
        this.lines.add(beforeIndex, line);
        this.updateRendering();
    }

    public void removeLine(int index) {
        this.checkNotDeleted();
        this.lines.remove(index);
        this.updateRendering();
    }

    void delete() {
        if (!this.deleted) {
            this.deleted = true;
            this.renderedHologram.delete();
        }
    }

    private void updateRendering() {
        this.renderedHologram.setPosition(this.position);
        this.renderedHologram.getLines().clear();
        for (InternalHologramLine serializedLine : this.lines) {
            serializedLine.appendTo(this.renderedHologram);
        }
    }

    private void checkNotDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("already deleted");
        }
    }

    public void callChangeEvent(InternalHologramChangeEvent.ChangeType changeType) {
        Bukkit.getPluginManager().callEvent((Event)new InternalHologramChangeEvent(this, changeType));
    }
}

