/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.LineEditingCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.QuickEditCommand;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandHelper;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class AddLineCommand
extends LineEditingCommand
implements QuickEditCommand {
    private final HologramCommandManager commandManager;
    private final InternalHologramEditor hologramEditor;

    public AddLineCommand(HologramCommandManager commandManager, InternalHologramEditor hologramEditor) {
        super("addLine", new String[0]);
        this.setMinArgs(2);
        this.setUsageArgs("<hologram> <text>");
        this.setDescription("Adds a line to a hologram.");
        this.commandManager = commandManager;
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        String serializedLine = Strings.joinFrom(" ", args, 1);
        InternalHologramLine line = this.hologramEditor.parseHologramLine(serializedLine);
        hologram.addLine(line);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_LINES);
        sender.sendMessage(ColorScheme.PRIMARY + "Line added.");
        this.commandManager.sendQuickEditCommands(context, hologram);
    }

    @Override
    public String getActionName() {
        return "Add";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> hologramNames = this.hologramEditor.getHolograms().stream().map(InternalHologram::getName).collect(Collectors.toList());
            return CommandHelper.filterStartingWith(args[0], hologramNames);
        }
        if (args[args.length - 1].isEmpty()) {
            return Collections.singletonList("<text>");
        }
        return Collections.emptyList();
    }
}

