/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.tracking;

import java.util.Map;
import java.util.WeakHashMap;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.core.tick.TickClock;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.collection.CaseInsensitiveString;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;

class PlaceholderExceptionHandler {
    private final TickClock tickClock;
    private final Map<CaseInsensitiveString, Long> lastErrorLogByPlaceholderContent;

    PlaceholderExceptionHandler(TickClock tickClock) {
        this.tickClock = tickClock;
        this.lastErrorLogByPlaceholderContent = new WeakHashMap<CaseInsensitiveString, Long>();
    }

    void handle(PlaceholderException exception, PlaceholderOccurrence placeholderOccurrence) {
        CaseInsensitiveString unparsedContent = placeholderOccurrence.getUnparsedContent();
        Long lastErrorLog = this.lastErrorLogByPlaceholderContent.get(unparsedContent);
        long currentTick = this.tickClock.getCurrentTick();
        if (lastErrorLog != null && currentTick - lastErrorLog < 20L) {
            return;
        }
        this.lastErrorLogByPlaceholderContent.put(unparsedContent, currentTick);
        Log.warning("The placeholder {" + unparsedContent + "} registered by the plugin " + exception.getPlaceholderExpansion().getPluginName() + " generated an exception.", exception.getCause());
    }
}

