/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.listener;

import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkListener
implements Listener {
    private final Plugin plugin;
    private final APIHologramManager apiHologramManager;
    private final V2HologramManager v2HologramManager;

    public ChunkListener(Plugin plugin, APIHologramManager apiHologramManager, V2HologramManager v2HologramManager) {
        this.plugin = plugin;
        this.apiHologramManager = apiHologramManager;
        this.v2HologramManager = v2HologramManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        this.apiHologramManager.onWorldUnload(world);
        this.v2HologramManager.onWorldUnload(world);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        this.apiHologramManager.onWorldLoad(world);
        this.v2HologramManager.onWorldLoad(world);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        if (Bukkit.isPrimaryThread()) {
            this.onChunkUnload(chunk);
        } else {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.onChunkUnload(chunk));
        }
    }

    private void onChunkUnload(Chunk chunk) {
        this.apiHologramManager.onChunkUnload(chunk);
        this.v2HologramManager.onChunkUnload(chunk);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        if (!chunk.isLoaded()) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.onChunkLoad(chunk);
        } else {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.onChunkLoad(chunk));
        }
    }

    private void onChunkLoad(Chunk chunk) {
        this.apiHologramManager.onChunkLoad(chunk);
        this.v2HologramManager.onChunkLoad(chunk);
    }
}

